<?php
require_once __DIR__ . '/includes/db.php'; // adjust if different

if (empty($_GET['code'])) {
  $message = "<div class='alert alert-danger'>Invalid verification link.</div>";
} else {
  $verification_code = trim($_GET['code']);

  // Check if user exists with this code
  $stmt = $pdo->prepare("SELECT id, fullname, is_verified FROM users WHERE verification_code = ?");
  $stmt->execute([$verification_code]);
  $user = $stmt->fetch(PDO::FETCH_ASSOC);

  if (!$user) {
    $message = "<div class='alert alert-danger'>Invalid or expired verification code.</div>";
  } elseif ($user['is_verified'] == 1) {
    $message = "<div class='alert alert-info'>Your account has already been verified. <a href='login'>Login here</a>.</div>";
  } else {
    // Update to mark user verified
    $stmt = $pdo->prepare("UPDATE users SET is_verified = 1, verification_code = NULL WHERE id = ?");
    $stmt->execute([$user['id']]);
    $message = "
      <div class='alert alert-success'>
        Hi <b>{$user['fullname']}</b>, your account has been successfully verified! 🎉
        <br><a href='login' class='btn btn-primary btn-sm mt-2'>Proceed to Login</a>
      </div>";
  }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Verify Account - Bmellonglobal</title>

  <link rel="icon" href="/assets/img/favicon.ico">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="/assets/css/style.css">
  <link rel="stylesheet" href="/assets/css/dark-mode.css">
</head>
<body>
  <main class="py-5">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-md-6 col-lg-5">
          <div class="card shadow-sm">
            <div class="card-body p-4 text-center">
              <img src="/assets/img/logo.png" alt="Bmellonglobal" class="mb-3" style="width:100px;">
              <h4 class="mb-3 text-primary">Account Verification</h4>
              <?= $message ?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </main>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
