<?php 
include 'includes/header.php'; 

if (!isset($_SESSION['user_id'])) {
    header("Location: login");
    exit;
}

$user_id = $_SESSION['user_id'];

$stmt = $pdo->prepare("SELECT * 
                       FROM users WHERE id = ? LIMIT 1");
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

?>

<div class="container py-4">

  <h4 class="fw-bold mb-4">Bank Account Information</h4>

  <div class="card p-3 shadow-sm border-0">

    <p class="mb-2">
      <strong>Account Name:</strong><br>
      <?= htmlspecialchars($user['firstname'].' '.$user['lastname']) ?>
    </p>

    <p class="mb-2">
      <strong>Account Number:</strong><br>
      <?= htmlspecialchars($user['account_number']) ?>
    </p>

    <p class="mb-2">
      <strong>Account Type:</strong><br>
      Savings Account
    </p>

    <p class="mb-2">
      <strong>Current Balance:</strong><br>
      ₦<?= number_format($user['account_balance'], 2) ?>
    </p>

    <p class="mb-2">
      <strong>Status:</strong><br>
      <span class="badge 
        <?= $user['status'] === 'Active' ? 'bg-danger' : 'bg-success' ?>">
        <?= $user['status'] ?>
      </span>
    </p>

    <p class="mb-0">
      <strong>Date Created:</strong><br>
      <?= date('d M Y', strtotime($user['created_at'])) ?>
    </p>

  </div>

</div>

<?php include 'includes/footer.php'; ?>
