<?php
// user/transfer.php
session_start();
require_once __DIR__ . '/../includes/db.php';

// Auth
if (empty($_SESSION['user_id'])) {
  header('Location: /login');
  exit;
}

// Fetch user
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
  session_destroy();
  header('Location: /login');
  exit;
}

// Block if not verified or suspended
if ((int)$user['is_verified'] === 0 || strtolower($user['status']) === 'pending') {
  // simplified message — you already have a pattern for this
  echo "<p class='alert alert-warning'>Account not verified / pending. Please contact us.</p>";
  exit;
}

// Safe values for JS
$js_user = [
  'id' => (int)$user['id'],
  'account_number' => $user['account_number'],
  'balance' => number_format((float)$user['account_balance'], 2),
  'raw_balance' => (float)$user['account_balance'],
  'currency' => htmlspecialchars($user['currency'] ?? '₦'),
  'has_card' => (int)$user['has_card']
];
?>

<?php include('includes/header.php'); ?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<?php /* minimal navbar + matching dashboard look */ ?>
<nav class="navbar navbar-expand-lg navbar-dark px-3" style="background:linear-gradient(90deg,#0f2027,#203a43);">
    
  <div class="ms-auto text-white">Balance: <span id="displayBalance"><?= htmlspecialchars($js_user['currency']) ?> <?= $js_user['balance'] ?></span></div>
</nav>

<style>
            .badge-overlay {
    position: absolute;
    top: 8px;
    right: 7px;
    background: red;
    color: #fff;
    font-size: 0.40rem;
    padding: 2px 4px;
    border-radius: 50%;
    line-height: 1;
    font-weight: bold;
}

        </style>
        
        
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

<div class="container py-4">
  <div class="row justify-content-center">
    <div class="col-lg-8">
      <div class="card shadow-sm">
        <div class="card-body">
          <h4 class="mb-3">Transfer Money</h4>

          <!-- Transfer type tabs -->
          <ul class="nav nav-tabs mb-3" id="transferTypeTab" role="tablist">
            <li class="nav-item" role="presentation">
              <button class="nav-link active" id="interbank-tab" data-bs-toggle="tab" data-type="interbank" type="button" role="tab">Interbank</button>
            </li>
            <li class="nav-item" role="presentation">
              <button class="nav-link" id="local-tab" data-bs-toggle="tab" data-type="local" type="button" role="tab">Local</button>
            </li>
            <li class="nav-item" role="presentation">
              <button class="nav-link" id="intl-tab" data-bs-toggle="tab" data-type="international" type="button" role="tab">Intl</button>
            </li>
          </ul>

          <form id="transferForm" class="needs-validation" novalidlate>
  <input type="hidden" name="type" id="transfer_type" value="interbank">

  <!-- Interbank Only -->
  <div class="mb-3 interbank-field">
    <label class="form-label">Recipient Account Number</label>
    <input type="text" name="recipient_account" id="recipient_account" class="form-control" placeholder="e.g. 0123456789">
    <div class="invalid-feedback">Please enter recipient account number.</div>
  </div>

  <div class="mb-3 interbank-field">
    <label class="form-label">Recipient Name (auto lookup)</label>
    <input type="text" id="recipient_name" class="form-control" readonly placeholder="Recipient name will appear automatically">
  </div>


  <!-- Local Transfer Fields -->
  <div class="mb-3 local-field d-none">
    <label class="form-label">Recipient Name</label>
    <input type="text" name="local_recipient_name" id="local_recipient_name" class="form-control" placeholder="Enter recipient full name">
  </div>

  <div class="mb-3 local-field d-none">
    <label class="form-label">Bank Name</label>
    <div class="input-group">
    <span class="input-group-text position-relative">
    <i class="fa fa-bank"></i><!-- Overlay badge -->
            <span class="badge-overlay">.</span></span>
    <input type="text" name="local_bank_name" id="local_bank_name" class="form-control" placeholder="Enter bank name">
  </div>
  </div>

  <div class="mb-3 local-field d-none">
    <label class="form-label">Account Number</label>
    <input type="text" name="local_account_number" id="local_account_number" class="form-control" placeholder="e.g. 1234567890">
  </div>


  <!-- International Transfer Fields -->
  <div class="mb-3 intl-field d-none">
    <label class="form-label">Recipient Name</label>
    <input type="text" name="intl_recipient_name" id="intl_recipient_name" class="form-control" placeholder="Enter recipient full name">
  </div>

  <div class="mb-3 intl-field d-none">
    <label class="form-label">IBAN (Account Number)</label>
    
    <input type="text" name="intl_iban" id="intl_iban" class="form-control" placeholder="Enter IBAN">
  </div>
  
  
  <div class="mb-3 intl-field d-none">
    <label class="form-label">Country</label>
    <div class="input-group">
        <span class="input-group-text position-relative">
    <i class="fa fa-globe"></i><!-- Overlay badge -->
            <span class="badge-overlay">.</span></span>
    <select  class="form-select">
      <option value="">Select Country</option>

      <option value="Afghanistan">Afghanistan</option>
      <option value="Albania">Albania</option>
      <option value="Algeria">Algeria</option>
      <option value="Andorra">Andorra</option>
      <option value="Angola">Angola</option>
      <option value="Argentina">Argentina</option>
      <option value="Armenia">Armenia</option>
      <option value="Australia">Australia</option>
      <option value="Austria">Austria</option>
      <option value="Azerbaijan">Azerbaijan</option>
      <option value="Bahamas">Bahamas</option>
      <option value="Bahrain">Bahrain</option>
      <option value="Bangladesh">Bangladesh</option>
      <option value="Barbados">Barbados</option>
      <option value="Belarus">Belarus</option>
      <option value="Belgium">Belgium</option>
      <option value="Belize">Belize</option>
      <option value="Benin">Benin</option>
      <option value="Bhutan">Bhutan</option>
      <option value="Bolivia">Bolivia</option>
      <option value="Bosnia and Herzegovina">Bosnia and Herzegovina</option>
      <option value="Botswana">Botswana</option>
      <option value="Brazil">Brazil</option>
      <option value="Brunei">Brunei</option>
      <option value="Bulgaria">Bulgaria</option>
      <option value="Burkina Faso">Burkina Faso</option>
      <option value="Burundi">Burundi</option>
      <option value="Cambodia">Cambodia</option>
      <option value="Cameroon">Cameroon</option>
      <option value="Canada">Canada</option>
      <option value="Cape Verde">Cape Verde</option>
      <option value="Central African Republic">Central African Republic</option>
      <option value="Chad">Chad</option>
      <option value="Chile">Chile</option>
      <option value="China">China</option>
      <option value="Colombia">Colombia</option>
      <option value="Comoros">Comoros</option>
      <option value="Congo">Congo</option>
      <option value="Costa Rica">Costa Rica</option>
      <option value="Croatia">Croatia</option>
      <option value="Cuba">Cuba</option>
      <option value="Cyprus">Cyprus</option>
      <option value="Czech Republic">Czech Republic</option>
      <option value="Denmark">Denmark</option>
      <option value="Djibouti">Djibouti</option>
      <option value="Dominica">Dominica</option>
      <option value="Dominican Republic">Dominican Republic</option>
      <option value="DR Congo">DR Congo</option>
      <option value="Ecuador">Ecuador</option>
      <option value="Egypt">Egypt</option>
      <option value="El Salvador">El Salvador</option>
      <option value="Equatorial Guinea">Equatorial Guinea</option>
      <option value="Eritrea">Eritrea</option>
      <option value="Estonia">Estonia</option>
      <option value="Eswatini">Eswatini</option>
      <option value="Ethiopia">Ethiopia</option>
      <option value="Fiji">Fiji</option>
      <option value="Finland">Finland</option>
      <option value="France">France</option>
      <option value="Gabon">Gabon</option>
      <option value="Gambia">Gambia</option>
      <option value="Georgia">Georgia</option>
      <option value="Germany">Germany</option>
      <option value="Ghana">Ghana</option>
      <option value="Greece">Greece</option>
      <option value="Grenada">Grenada</option>
      <option value="Guatemala">Guatemala</option>
      <option value="Guinea">Guinea</option>
      <option value="Guinea-Bissau">Guinea-Bissau</option>
      <option value="Guyana">Guyana</option>
      <option value="Haiti">Haiti</option>
      <option value="Honduras">Honduras</option>
      <option value="Hungary">Hungary</option>
      <option value="Iceland">Iceland</option>
      <option value="India">India</option>
      <option value="Indonesia">Indonesia</option>
      <option value="Iran">Iran</option>
      <option value="Iraq">Iraq</option>
      <option value="Ireland">Ireland</option>
      <option value="Israel">Israel</option>
      <option value="Italy">Italy</option>
      <option value="Ivory Coast">Ivory Coast</option>
      <option value="Jamaica">Jamaica</option>
      <option value="Japan">Japan</option>
      <option value="Jordan">Jordan</option>
      <option value="Kazakhstan">Kazakhstan</option>
      <option value="Kenya">Kenya</option>
      <option value="Kuwait">Kuwait</option>
      <option value="Kyrgyzstan">Kyrgyzstan</option>
      <option value="Laos">Laos</option>
      <option value="Latvia">Latvia</option>
      <option value="Lebanon">Lebanon</option>
      <option value="Lesotho">Lesotho</option>
      <option value="Liberia">Liberia</option>
      <option value="Libya">Libya</option>
      <option value="Liechtenstein">Liechtenstein</option>
      <option value="Lithuania">Lithuania</option>
      <option value="Luxembourg">Luxembourg</option>
      <option value="Madagascar">Madagascar</option>
      <option value="Malawi">Malawi</option>
      <option value="Malaysia">Malaysia</option>
      <option value="Maldives">Maldives</option>
      <option value="Mali">Mali</option>
      <option value="Malta">Malta</option>
      <option value="Mauritania">Mauritania</option>
      <option value="Mauritius">Mauritius</option>
      <option value="Mexico">Mexico</option>
      <option value="Moldova">Moldova</option>
      <option value="Monaco">Monaco</option>
      <option value="Mongolia">Mongolia</option>
      <option value="Montenegro">Montenegro</option>
      <option value="Morocco">Morocco</option>
      <option value="Mozambique">Mozambique</option>
      <option value="Myanmar">Myanmar</option>
      <option value="Namibia">Namibia</option>
      <option value="Nepal">Nepal</option>
      <option value="Netherlands">Netherlands</option>
      <option value="New Zealand">New Zealand</option>
      <option value="Nicaragua">Nicaragua</option>
      <option value="Niger">Niger</option>
      <option value="Nigeria">Nigeria</option>
      <option value="North Korea">North Korea</option>
      <option value="North Macedonia">North Macedonia</option>
      <option value="Norway">Norway</option>
      <option value="Oman">Oman</option>
      <option value="Pakistan">Pakistan</option>
      <option value="Palestine">Palestine</option>
      <option value="Panama">Panama</option>
      <option value="Papua New Guinea">Papua New Guinea</option>
      <option value="Paraguay">Paraguay</option>
      <option value="Peru">Peru</option>
      <option value="Philippines">Philippines</option>
      <option value="Poland">Poland</option>
      <option value="Portugal">Portugal</option>
      <option value="Qatar">Qatar</option>
      <option value="Romania">Romania</option>
      <option value="Russia">Russia</option>
      <option value="Rwanda">Rwanda</option>
      <option value="Saudi Arabia">Saudi Arabia</option>
      <option value="Senegal">Senegal</option>
      <option value="Serbia">Serbia</option>
      <option value="Seychelles">Seychelles</option>
      <option value="Sierra Leone">Sierra Leone</option>
      <option value="Singapore">Singapore</option>
      <option value="Slovakia">Slovakia</option>
      <option value="Slovenia">Slovenia</option>
      <option value="Somalia">Somalia</option>
      <option value="South Africa">South Africa</option>
      <option value="South Korea">South Korea</option>
      <option value="South Sudan">South Sudan</option>
      <option value="Spain">Spain</option>
      <option value="Sri Lanka">Sri Lanka</option>
      <option value="Sudan">Sudan</option>
      <option value="Suriname">Suriname</option>
      <option value="Sweden">Sweden</option>
      <option value="Switzerland">Switzerland</option>
      <option value="Syria">Syria</option>
      <option value="Taiwan">Taiwan</option>
      <option value="Tajikistan">Tajikistan</option>
      <option value="Tanzania">Tanzania</option>
      <option value="Thailand">Thailand</option>
      <option value="Togo">Togo</option>
      <option value="Trinidad and Tobago">Trinidad and Tobago</option>
      <option value="Tunisia">Tunisia</option>
      <option value="Turkey">Turkey</option>
      <option value="Turkmenistan">Turkmenistan</option>
      <option value="Uganda">Uganda</option>
      <option value="Ukraine">Ukraine</option>
      <option value="United Arab Emirates">United Arab Emirates</option>
      <option value="United Kingdom">United Kingdom</option>
      <option value="United States">United States</option>
      <option value="Uruguay">Uruguay</option>
      <option value="Uzbekistan">Uzbekistan</option>
      <option value="Venezuela">Venezuela</option>
      <option value="Vietnam">Vietnam</option>
      <option value="Yemen">Yemen</option>
      <option value="Zambia">Zambia</option>
      <option value="Zimbabwe">Zimbabwe</option>
    </select>
  </div>
  </div>

  <div class="mb-3 intl-field d-none">
    <label class="form-label">SWIFT / BIC Code</label>
    <input type="text" name="intl_swift" id="intl_swift" class="form-control" placeholder="SWIFT/BIC code">
  </div>

  
  <div class="mb-3 intl-field d-none">
    <label class="form-label">Bank Name</label>
    <div class="input-group">
    <span class="input-group-text position-relative">
    <i class="fa fa-bank"></i><!-- Overlay badge -->
            <span class="badge-overlay">.</span></span>
    <input type="text" name="intl_bank_name" id="intl_bank_name" class="form-control" placeholder="Enter bank name">
  </div>
  </div>
  
  


  <div class="mb-3">
    <label class="form-label">Amount (<?= htmlspecialchars($js_user['currency']) ?>)</label>
    <div class="input-group">
    <span class="input-group-text position-relative">
            <i class="fa fa-money"></i>

            <!-- Overlay badge -->
            <span class="badge-overlay">.</span>
        </span>
    <input type="number" step="0.01" name="amount" id="amount" class="form-control" min="0.01" required>
  </div>
  
    <div class="invalid-feedback">Enter a valid amount.</div>
  </div>

  <div class="mb-3">
    <label class="form-label">Remark / Description</label>
    <input type="text" name="description" id="description" class="form-control" maxlength="255" placeholder="Optional">
  </div>

  <div class="mb-3">
    <label class="form-label">Transfer PIN</label>

    <div class="input-group">
        <span class="input-group-text position-relative">
            <i class="fa fa-key"></i>

            <!-- Overlay badge -->
            <span class="badge-overlay">.</span>
        </span>
        
        

        <input type="password" name="transfer_pin" id="transfer_pin"
            class="form-control" maxlength="6" required
            placeholder="Enter your 4-6 digit transfer PIN">
    </div>

    <div class="invalid-feedback">Transfer PIN required.</div>
</div>

  

<!-- PROCEED BUTTON (Visible first) -->
<button type="button" id="proceed-btn" class="btn btn-primary">
    Proceed
</button>

<!-- LOADER (Hidden) -->
<div id="otp-loader" class="text-center mb-3" style="display:none;">
    <div class="spinner-border text-primary" role="status" style="width:2.5rem; height:2.5rem;"></div>
    <p class="mt-2">Please wait...</p>
</div>


<!-- OTP SECTION (Hidden initially) -->
<div class="mb-3" id="otp-section" style="display:none; opacity:0; transition: opacity 0.8s ease;">
    <label class="form-label"> Enter OTP</label>
<div class="input-group">
        <span class="input-group-text position-relative">
            <i class="fa fa-user"></i>

            <!-- Overlay badge -->
            <span class="badge-overlay">.</span>
        </span>
        
        

        <input type="password" name="otp" id="otp"
            class="form-control" maxlength="6" required
            placeholder="Enter your OTP">
    </div>
<div class="invalid-feedback">Transfer PIN required.</div>
</div>

<div id="formMessage" class="mb-3"></div>

  <div class="d-flex justify-content-between">
    <button type="button" id="previewBtn" class="preview-btn btn btn-outline-primary" style="display:none;">Preview</button>
    <button type="submit" class="btn btn-primary" id="send-btn" style="display:none;">Send Transfer</button>
  </div>




</form>


        </div>
      </div>

      <p class="mt-2 text-muted small">Note: Interbank transfers only succeed when recipient account exists in our system. International transfers may take longer and are processed externally.</p>
    </div>
  </div>
</div>

<!-- Preview Modal -->
<div class="modal fade" id="previewModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Confirm Transfer</h5>
        <button class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div id="previewBody"></div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        <button id="confirmSend" class="btn btn-primary">Confirm & Send</button>
      </div>
    </div>
  </div>
</div>

<!-- Result Modal -->
<div class="modal fade" id="resultModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="resultTitle">Result</h5>
        <button class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body" id="resultBody"></div>
      <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<script>
const CURRENT = <?php echo json_encode($js_user) ?>;
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
(function(){
  const transferTypeTab = document.getElementById('transferTypeTab');
  const transferTypeInput = document.getElementById('transfer_type');
  const recipientInput = document.getElementById('recipient_account');
  const recipientName = document.getElementById('recipient_name');
  const previewBtn = document.getElementById('previewBtn');
  const previewModal = new bootstrap.Modal(document.getElementById('previewModal'));
  const resultModal = new bootstrap.Modal(document.getElementById('resultModal'));
  const previewBody = document.getElementById('previewBody');
  const confirmSend = document.getElementById('confirmSend');
  const form = document.getElementById('transferForm');
  const formMessage = document.getElementById('formMessage');

  // Switch tab => set type
  document.querySelectorAll('#transferTypeTab .nav-link').forEach(btn => {
    btn.addEventListener('click', () => {
      document.querySelectorAll('#transferTypeTab .nav-link').forEach(b=>b.classList.remove('active'));
      btn.classList.add('active');
      transferTypeInput.value = btn.dataset.type || btn.getAttribute('data-type') || btn.id.replace('-tab','');
      // clear recipient name on type change
      recipientName.value = '';
    });
  });

  // Live lookup for recipient (only meaningful for interbank/local)
  let lookupTimer = 0;
  recipientInput.addEventListener('input', (e) => {
    recipientName.value = '';
    clearTimeout(lookupTimer);
    const acct = recipientInput.value.trim();
    if (!acct) return;
    lookupTimer = setTimeout(() => {
      fetch('../actions/lookup_account', {
        method: 'POST',
        headers: { 'Accept': 'application/json' },
        body: new URLSearchParams({ account_number: acct })
      }).then(r => r.json()).then(data => {
        if (data.status === 'success') {
          recipientName.value = data.firstname;
        } else {
          recipientName.value = data.message || 'Not found';
        }
      }).catch(()=> { recipientName.value = 'Lookup error'; });
    }, 400);
  });

  // Preview
  // Preview (dynamic display by transfer type)
previewBtn.addEventListener('click', (e) => {
  if (!form.checkValidity()) {
    form.classList.add('was-validated');
    return;
  }

  const type = transferTypeInput.value;
  const desc = document.getElementById('description').value.trim();
  const amt = parseFloat(document.getElementById('amount').value).toFixed(2);

  let previewHTML = `
    <p><strong>Transfer Type:</strong> ${type.toUpperCase()}</p>
    <p><strong>Amount:</strong> ${CURRENT.currency} ${amt}</p>
    <p><strong>Remark:</strong> ${desc || '-'}</p>
    <hr>
  `;

  if (type === 'interbank') {
    previewHTML += `
      <p><strong>Sender Account:</strong> ${CURRENT.account_number}</p>
      <p><strong>Recipient Account:</strong> ${recipientInput.value}</p>
      <p><strong>Recipient Name:</strong> ${recipientName.value || 'N/A'}</p>
    `;
  }

  if (type === 'local') {
    previewHTML += `
      <p><strong>Sender Account:</strong> ${CURRENT.account_number}</p>
      <p><strong>Recipient Name:</strong> ${local_recipient_name.value}</p>
      <p><strong>Bank Name:</strong> ${local_bank_name.value}</p>
      <p><strong>Account Number:</strong> ${local_account_number.value}</p>
    `;
  }

  if (type === 'international') {
    previewHTML += `
      <p><strong>Sender Account:</strong> ${CURRENT.account_number}</p>
      <p><strong>Recipient Name:</strong> ${intl_recipient_name.value}</p>
      <p><strong>Bank Name:</strong> ${intl_bank_name.value}</p>
      <p><strong>IBAN:</strong> ${intl_iban.value}</p>
    `;
  }

  previewHTML += `
    <hr>
    <p class="text-danger"><small>Please confirm details carefully. Transfers may not be reversible.</small></p>
  `;

  previewBody.innerHTML = previewHTML;
  previewModal.show();
});


  // Confirm send
  confirmSend.addEventListener('click', async () => {
  previewModal.hide();

  const formData = new FormData(form);
  const type = formData.get('type');

  let endpoint = '';
  if (type === 'interbank') endpoint = '../actions/transfer_action';
  if (type === 'local') endpoint = '../actions/local_transfer';
  if (type === 'international') endpoint = '../actions/international_transfer';

  formMessage.innerHTML = `<div class="alert alert-info">Processing transfer...</div>`;

  confirmSend.disabled = true;
  confirmSend.innerHTML = `
    <span class="spinner-border spinner-border-sm me-2"></span>
    Processing...
  `;

  try {
    const res = await fetch(endpoint, {
      method: 'POST',
      body: new URLSearchParams(formData)
    });

    const data = await res.json().catch(()=>({ status:'error', message:'Invalid response' }));

    if (data.status === 'success') {
      if (data.redirect) return window.location.href = data.redirect;

      document.getElementById('resultTitle').textContent = 'Transfer Successful';
      document.getElementById('resultBody').innerHTML = `
        <div class="alert alert-success">${data.message}</div>
      `;
      resultModal.show();
      formMessage.innerHTML = '';

    } else {
      formMessage.innerHTML = `<div class="alert alert-danger">${data.message}</div>`;
    }

  } catch (err) {
    formMessage.innerHTML = `
      <div class="alert alert-danger">
        A server error occurred. Please try again.<br>
        <small>${err.message}</small>
      </div>
    `;
  } finally {
    confirmSend.disabled = false;
    confirmSend.innerHTML = `Confirm & Send`;
  }
});


  
  
  
  // Show and hide fields depending on transfer type
function updateTransferFields(type){
  document.querySelectorAll('.interbank-field').forEach(el => el.classList.toggle('d-none', type !== 'interbank'));
  document.querySelectorAll('.local-field').forEach(el => el.classList.toggle('d-none', type !== 'local'));
  document.querySelectorAll('.intl-field').forEach(el => el.classList.toggle('d-none', type !== 'international'));
}

document.querySelectorAll('#transferTypeTab .nav-link').forEach(btn => {
  btn.addEventListener('click', () => {
    const selected = btn.dataset.type;
    updateTransferFields(selected);
  });
});

// initialize on load
updateTransferFields('interbank');


  // Form submit directly (if user presses submit instead of preview)
  form.addEventListener('submit', (e) => {
    e.preventDefault();
    previewBtn.click();
  });

})();
</script>













<script>
document.addEventListener("DOMContentLoaded", function () {

    const proceedBtn = document.getElementById("proceed-btn");
    const previewBtn = document.querySelector(".preview-btn"); // <-- class used here
    const sendBtn = document.getElementById("send-btn");
    const otpLoader = document.getElementById("otp-loader");
    const otpSection = document.getElementById("otp-section");

    proceedBtn.addEventListener("click", function () {

        // Hide proceed button
        proceedBtn.style.display = "none";

        // Show loader
        otpLoader.style.display = "block";

        setTimeout(function () {

            // Hide loader
            otpLoader.style.display = "none";

            // Show OTP with fade-in animation
            otpSection.style.display = "block";
            setTimeout(() => {
                otpSection.style.opacity = 1;
            }, 50);

            // Show Preview Transfer button
            previewBtn.style.display = "block";

            // Show Send Transfer button
            sendBtn.style.display = "block";

        }, 7000);
    });

});
</script>







<?php include('includes/footer.php'); ?>