<?php 
include 'includes/header.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login");
    exit;
}

$user_id = $_SESSION['user_id'];

$stmt = $pdo->prepare("SELECT * FROM transactions WHERE user_id = ? ORDER BY id DESC LIMIT 20");
$stmt->execute([$user_id]);
$transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container py-4">

  <h4 class="fw-bold mb-3">Transaction History</h4>

  <?php if (count($transactions) < 1): ?>
    <div class="alert alert-info text-center">
      No transactions yet.
    </div>
  <?php endif; ?>

  <div class="list-group">

    <?php foreach ($transactions as $t): ?>
      
      <div class="list-group-item border-0 border-bottom py-3 d-flex align-items-center justify-content-between">
        
        <div class="d-flex align-items-center">

          <!-- Icon Circle -->
          <div class="rounded-circle me-3 d-flex align-items-center justify-content-center" 
            style="width:45px; height:45px; 
            background: <?= $t['type'] === 'credit' || $t['type'] === 'deposit' ? '#e6f9f0' : '#ffe8e8' ?>;
            color: <?= $t['type'] === 'credit' || $t['type'] === 'deposit' ? '#0a8f46' : '#c71f1f' ?>;">
            
            <i class="bi <?= $t['type'] === 'credit' || $t['type'] === 'deposit' ? 'bi-arrow-down-circle' : 'bi-arrow-up-circle' ?> fs-5"></i>
          </div>

          <div>
            <div class="fw-bold"><?= htmlspecialchars($t['description']) ?></div>
            <small class="text-muted"><?= date("M d, Y • h:i A", strtotime($t['created_at'])) ?></small>
          </div>

        </div>
        
        
        <!-- Amount -->
        <div class="text-end fw-bold" 
          style="color: <?= $t['type'] === 'credit' || $t['type'] === 'deposit' ? '#0a8f46' : '#c71f1f' ?>;">
            
            <span class="badge 
      <?php 
        if ($t['status'] === 'successful') echo 'bg-success'; 
        elseif ($t['status'] === 'pending') echo 'bg-warning';
        elseif ($t['status'] === 'reversed') echo 'bg-primary';
        else echo 'bg-warning text-dark';
      ?>
    ">
      <?= $t['status'] ?>
    </span>
            
          <?= $t['type'] === 'credit' || $t['type'] === 'deposit' ? '+' : '-' ?><?= $userData['currency'] ?><?= number_format($t['amount'], 2) ?>
        </div>

      </div>

    <?php endforeach; ?>

  </div>

</div>

<?php include 'includes/footer.php'; ?>
