<?php 
include 'includes/header.php'; 

if (!isset($_SESSION['user_id'])) {
    header("Location: login");
    exit;
}

$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$userData = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<div class="container py-4">

  <h4 class="fw-bold mb-3">Account Settings</h4>

  <!-- Profile Card -->
  <div class="card p-3 mb-4 shadow-sm border-0">
    <div class="d-flex align-items-center">
      <img src="uploads/<?= $userData['photo'] ?: 'default.png'; ?>" 
       class="rounded-circle shadow" width="80" height="80" style="object-fit: cover;">
       <br>
      <div>
        <h5 class="m-0"><?= htmlspecialchars($userData['firstname'].' '.$userData['lastname']); ?></h5>
        <small class="text-muted"><?= htmlspecialchars($userData['email']); ?></small>
      </div>
    </div>
  </div>
  

  <!-- Menu List -->
    <!-- Menu List -->
  <div class="list-group">

    <a href="profile_photo" class="list-group-item list-group-item-action py-3">
      <i class="bi bi-person me-2"></i> Update Photo
    </a>
    
    <a href="profile_edit" class="list-group-item list-group-item-action py-3">
      <i class="bi bi-person-lines-fill me-2"></i> Edit Profile
    </a>

    <a href="change_password" class="list-group-item list-group-item-action py-3">
      <i class="bi bi-shield-lock-fill me-2"></i> Change Password
    </a>

    <a href="change_pin" class="list-group-item list-group-item-action py-3">
      <i class="bi bi-key-fill me-2"></i> Change Transaction PIN
    </a>

    <a href="view_account" class="list-group-item list-group-item-action py-3">
      <i class="bi bi-bank me-2"></i> Bank Account Information
    </a>

    <a href="#" class="list-group-item list-group-item-action text-danger py-3 logout-trigger">
      <i class="bi bi-power me-2"></i> Logout
    </a>

  </div>


</div>



<?php include 'includes/footer.php'; ?>
