<?php
session_start();
require_once __DIR__ . '/../includes/db.php';

if (empty($_SESSION['user_id']) || empty($_GET['reference'])) {
    header("Location: dashboard");
    exit;
}

$reference = trim($_GET['reference']);

// Fetch transaction
$stmt = $pdo->prepare("SELECT * FROM transactions WHERE reference = ? AND user_id = ? LIMIT 1");
$stmt->execute([$reference, $_SESSION['user_id']]);
$txn = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$txn) { die("Invalid Receipt Reference"); }

// Fetch sender
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$txn['user_id']]);
$sender = $stmt->fetch(PDO::FETCH_ASSOC);

$sender_account = $txn['account_number'];

// --------------------------------------------------------
// DETERMINE RECIPIENT
// --------------------------------------------------------

$desc = $txn['description'];

// Default values from description (for external beneficiary)
$recipient_name = "External Beneficiary";
$recipient_acc  = "Unknown";
$recipient_bank = "Unknown";
$note = "N/A";

// Extract description fields
preg_match('/International Transfer to (.*?) \|/i', $desc, $m1);
preg_match('/Acct:\s*(.*?)\s*\|/i', $desc, $m2);
preg_match('/Bank:\s*(.*?)\s*(\||$)/i', $m3);
preg_match('/Note:\s*(.*)$/i', $m4);

if (!empty($m1)) $recipient_name = trim($m1[1]);
if (!empty($m2)) $recipient_acc  = trim($m2[1]);
if (!empty($m3)) $recipient_bank = trim($m3[1]);
if (!empty($m4)) $note = trim($m4[1]);

// --------------------------------------------------------
// CHECK IF RECIPIENT EXISTS IN USERS TABLE
// --------------------------------------------------------

$stmt = $pdo->prepare("SELECT * FROM users WHERE account_number = ? LIMIT 1");
$stmt->execute([$recipient_acc]);
$recipient = $stmt->fetch(PDO::FETCH_ASSOC);

if ($recipient) {
    // Recipient exists → Use DB details
    $recipient_name = $recipient['firstname'] . " " . $recipient['lastname'];
    $recipient_acc  = $recipient['account_number'];

    // If you store bank name inside database (optional)
    if (!empty($recipient['bank_name'])) {
        $recipient_bank = $recipient['bank_name'];
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Receipt</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">

<style>
body {
    background: #f5f7fa;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    padding: 10px;
}

.receipt-box {
    background: #fff;
    border-radius: 12px;
    padding: 18px;
    max-width: 450px;
    margin: auto;
    box-shadow: 0 3px 12px rgba(0,0,0,0.08);
}

.header {
    text-align: center;
    margin-bottom: 12px;
}

.header h4 {
    font-size: 1.2rem;
    font-weight: 600;
    color: #0d6efd;
    margin-bottom: 4px;
}

.header p {
    font-size: 0.8rem;
    color: #6c757d;
    margin-bottom: 0;
}

.amount-box {
    background: #e9f3ff;
    border-radius: 10px;
    padding: 10px;
    margin: 12px 0;
    text-align: center;
}

.amount-box .amount {
    font-size: 1.5rem;
    font-weight: 700;
    color: #0d6efd;
    margin: 0;
}

.section-title {
    font-size: 0.9rem;
    padding-left: 6px;
    border-left: 3px solid #0d6efd;
    font-weight: 600;
    margin-top: 18px;
    margin-bottom: 6px;
    color: #0d6efd;
}

.info-row {
    display: flex;
    justify-content: space-between;
    font-size: 0.85rem;
    padding: 4px 0;
    border-bottom: 1px dashed #e9ecef;
}

.info-row span:last-child {
    font-weight: 500;
}

.footer-btns {
    text-align: center;
    margin-top: 20px;
}

.footer-btns .btn {
    font-size: 0.85rem;
    border-radius: 25px;
    padding: 6px 20px;
}

@media (max-width: 400px) {
    .info-row {
        flex-direction: column;
        text-align: left;
    }
    .info-row span:last-child {
        margin-top: 2px;
    }
}
</style>
</head>

<body>

<div class="receipt-box">
<div class="brand-header text-center mb-3">
    <img src="../assets/img/logo.png" alt="Bank Logo" width="70">
    <p class="text-muted" style="font-size:0.8rem;">Secure Digital Banking</p>
</div>

    <div class="header">
        <h4>Transaction Receipt</h4>
        <p><?= date("d M Y, h:i A", strtotime($txn['created_at'])) ?></p>
    </div>

    <div class="amount-box">
        <p class="amount"><?= $sender['currency'] ?><?= number_format($txn['amount'],2) ?></p>
    </div>

    <div class="info-row"><span>Reference:</span><span><?= $txn['reference'] ?></span></div>

    <?php if($txn['status'] != 'successful'): ?>
    <div class="info-row"><span>Status: <span class="badge bg-warning"><?= ucfirst($txn['status']) ?></span></span></div>
    <?php else: ?>
    <div class="info-row"><span>Status: <span class="badge bg-success"><?= ucfirst($txn['status']) ?></span></span></div>
    <?php endif; ?>

    <div class="section-title">Sender</div>
    <div class="info-row"><span>Name:</span><span><?= $sender['firstname']." ".$sender['lastname'] ?></span></div> 
    <div class="info-row"><span>Account:</span><span><?= $sender['account_number'] ?></span></div>
 
    <!--<div class="section-title">Recipient</div>-->
    <!--<div class="info-row"><span>Name:</span><span><?= $recipient_name ?></span></div>-->
    <!--<div class="info-row"><span>Account:</span><span><?= $recipient_acc ?></span></div>-->
   

    <div class="section-title">Description</div>
    <p style="font-size:0.85rem; margin-top: -4px;"><?= $txn['description'] ?></p>

    <div class="footer-btns">
        <button onclick="window.print()" class="btn btn-primary me-2">Print</button>
        <a href="receipt_pdf?reference=<?= $txn['reference'] ?>" class="btn btn-success me-2">Download PDF</a>
        <a href="dashboard" class="btn btn-outline-secondary">Close</a>
    </div>

</div>

</body>
</html>
