<?php include 'includes/header.php'; 

if (!isset($_SESSION['user_id'])) {
    header("Location: login");
    exit;
}

// Get user
$stmt = $pdo->prepare("SELECT photo FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<div class="container py-4">

<div class="card p-4 shadow-sm border-0">

<h4 class="fw-bold mb-3 text-gradient">Profile Photo</h4>

<!-- ✅ Alerts -->
<?php if (isset($_GET['success'])): ?>
  <div class="alert alert-success alert-dismissible fade show" role="alert">
    <?= htmlspecialchars($_GET['success']); ?>
    <button class="btn-close" data-bs-dismiss="alert"></button>
  </div>
<?php endif; ?>

<?php if (isset($_GET['error'])): ?>
  <div class="alert alert-danger alert-dismissible fade show" role="alert">
    <?= htmlspecialchars($_GET['error']); ?>
    <button class="btn-close" data-bs-dismiss="alert"></button>
  </div>
<?php endif; ?>

<div class="text-center mb-4">
  <img src="uploads/<?= $user['photo'] ?: 'default.png'; ?>" 
       class="rounded-circle shadow" width="130" height="130" style="object-fit: cover;">
</div>

<form action="../actions/upload_photo" method="POST" enctype="multipart/form-data">
  <div class="mb-3">
    <label class="form-label">Select New Profile Photo</label>
    <input type="file" name="photo" accept="image/*" required class="form-control">
  </div>

  <button type="submit" class="btn btn-primary w-100 mt-2">Upload Photo</button>
</form>

</div>
</div>


<?php include 'includes/footer.php'; ?>