<?php 
include 'includes/header.php'; 

if (!isset($_SESSION['user_id'])) {
    header("Location: login");
    exit;
}

$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<div class="container py-4">
  <div class="card p-4 border-0 shadow-sm">

    <h4 class="fw-bold mb-3 text-gradient">Edit Profile</h4>

    <form action="../actions/update_profile" method="POST">
        
        <?php if (isset($_GET['success'])): ?>
      <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?= htmlspecialchars($_GET['success']); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      </div>
    <?php endif; ?>

    <?php if (isset($_GET['error'])): ?>
      <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?= htmlspecialchars($_GET['error']); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      </div>
    <?php endif; ?>

      <div class="mb-3">
        <label class="form-label">First Name</label>
        <input type="text" name="firstname" class="form-control" value="<?= htmlspecialchars($user['firstname']); ?>" required>
      </div>

      <div class="mb-3">
        <label class="form-label">Last Name</label>
        <input type="text" name="lastname" class="form-control" value="<?= htmlspecialchars($user['lastname']); ?>" required>
      </div>

      <div class="mb-3">
        <label class="form-label">Phone Number</label>
        <input type="text" name="phone" class="form-control" value="<?= htmlspecialchars($user['phone']); ?>" required>
      </div>

      <button class="btn btn-info w-100">Save Changes</button>
    </form>

  </div>
</div>

<?php include 'includes/footer.php'; ?>
