<?php
session_start();
require_once __DIR__ . '/../includes/db.php';

if (!empty($_SESSION['user_id'])) {
    // ✅ Save current login as last login before logout
    $stmt = $pdo->prepare("UPDATE users SET last_logout = NOW(), last_login = current_login WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
}

session_unset();
session_destroy();

// ✅ Redirect to login page
header("Location: ../login");
exit;
