<?php include('includes/header.php'); ?>

<div class="container py-4">
  <div class="card p-4">

    <h4 class="text-gradient mb-3">Request Loan</h4>
    <p class="text-muted small">Fill the form below to request a loan.</p>

    <form action="../actions/send_loan_request" method="POST">

      <div class="mb-3">
        <label class="form-label">Full Name</label>
        <input type="text" value="<?= htmlspecialchars($userData['firstname']) ?> <?= htmlspecialchars($userData['lastname']) ?>" class="form-control" readonly>
      </div>

      <div class="mb-3">
        <label class="form-label">Phone Number</label>
        <input type="text" name="phone" value="<?= htmlspecialchars($userData['phone']) ?>" required class="form-control">
      </div>

      <div class="mb-3">
        <label class="form-label">Loan Amount (<?= htmlspecialchars($userData['currency']) ?>)</label>
        <input type="number" name="loan_amount" required class="form-control" placeholder="Example: 50000">
      </div>

      <div class="mb-3">
        <label class="form-label">Loan Duration</label>
        <select name="duration" class="form-select" required>
            <option value="">-- Select Duration --</option>
            <option value="1 Month">1 Month</option>
            <option value="2 Months">2 Months</option>
            <option value="3 Months">3 Months</option>
            <option value="6 Months">6 Months</option>
        </select>
      </div>

      <div class="mb-3">
        <label class="form-label">Reason / Purpose of Loan</label>
        <textarea name="purpose" class="form-control" rows="3" required placeholder="Explain briefly"></textarea>
      </div>

      <button class="btn btn-info w-100">Submit Loan Request</button>

    </form>
  </div>
</div>

<?php include('includes/footer.php'); ?>
