<?php include('includes/header.php');?>

<!-- Dashboard -->
<div class="container py-4">
  <div class="row g-4">
    <!-- Profile Info -->
    <div class="col-md-4">
      <div class="profile-info mb-2">
        <img src="/assets/img/default-avatar.png" alt="Profile Picture">
        <h5 class="mt-3 mb-0">John Doe</i></h5>
        <small><?php echo $email; ?></small>
        <p class="mt-2 small"></i> Account No: <b><?php echo $account_number; ?></b></p>
        <p class="mt-2 small"></i> Account Type: <b><?php echo $user_account_type; ?></b></p>

      </div>

      <div class="profile-info">
        <h5 class="text-gradient">Security Info.</h5>
        <p style="text-align: left;"><strong>Last Login:</strong> <?php echo $last_login; ?></p>
        <p style="text-align: left;"><strong>IP Address:</strong> <?php echo $last_ip; ?></p>
        <!--<p style="text-align: left;"><strong>Device:</strong> <?php echo $device; ?></p>-->

      </div>
    </div>

    <!-- Dashboard Content -->
    <div class="col-md-8">
      <div class="card p-4 mb-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
          <h5 class="text-gradient">Account Overview</h5>
          <button id="toggleBalance" class="btn btn-outline-info btn-sm">
            <i class="bi bi-eye-slash"></i> Hide
          </button>
        </div>
        <div class="row">
          <div class="col-sm-12 mb-3">
            <div class="card p-3 text-center bg-success bg-opacity-25">
              <h6>Account Balance</h6>
              <h3 class="balance">₦450,000</h3>
            </div>
          </div>
          <div class="col-sm-6 mb-3">
            <div class="card p-3 text-center bg-danger bg-opacity-25">
              <h6>Last Debit</h6>
              <h3 class="balance">₦20,000</h3>
            </div>
          </div>
          <div class="col-sm-6 mb-3">
            <div class="card p-3 text-center bg-success bg-opacity-25">
              <h6>Last Credit</h6>
              <h3 class="balance">₦100,000</h3>
            </div>
          </div>
        </div>
      </div>
      
      
      
      <?php
$cardNumber = $userData['card_number'] ?? null;
$cardStatus = $userData['card_status'] ?? 'None';

function maskCard($number) {
    if (!$number) return "**** **** **** ****";
    return substr($number, 0, 4) . " **** **** " . substr($number, -4);
}
?>
<style>
.card-animated {
  transition: transform 0.7s ease, box-shadow 0.7s ease;
  transform-style: preserve-3d;
}
.card-animated:hover {
  transform: scale(1.03) rotateX(5deg) rotateY(5deg);
  box-shadow: 0px 10px 35px rgba(0,0,0,0.25);
}
</style>

<div class="card shadow p-4 mb-4 card-animated" style="border-radius: 20px; background: linear-gradient(135deg, #0072ff, #00c6ff); color: white;">

  <div class="d-flex justify-content-between">
    <strong style="font-size: 18px;">BMELLON INTL BANK</strong>
    <img src="assets/img/chip.png" width="45">
  </div>

  <div class="mt-4" style="font-size: 22px; letter-spacing: 3px;">
    <?= maskCard($cardNumber) ?>
  </div>

  <div class="mt-3">
    <small>CARD HOLDER</small><br>
    <strong style="font-size: 17px;">
      <?= htmlspecialchars($userData['firstname'] . ' ' . $userData['lastname']) ?>
    </strong>
  </div>

  <div class="mt-3">
    <small>STATUS</small><br>
    <span class="badge 
      <?php 
        if ($cardStatus === 'Approved') echo 'bg-success'; 
        elseif ($cardStatus === 'Frozen') echo 'bg-danger';
        elseif ($cardStatus === 'Shipped') echo 'bg-info';
        elseif ($cardStatus === 'Delivered') echo 'bg-primary';
        else echo 'bg-warning text-dark';
      ?>
    ">
      <?= $cardStatus ?>
    </span>
  </div>

</div>



      <!-- Quick Actions -->
      <div class="card p-4 mb-4">
        <h5 class="mb-3 text-gradient">Quick Actions</h5>
        <div class="row">
          <div class="col-md-4 mb-3">
            <div class="card action-card p-3 text-center">
              <i class="bi bi-arrow-left-right display-5 text-info"></i>
              <h6 class="mt-2">Transfer</h6>
              <p class="small text-secondary">Send money easily</p>
            </div>
          </div>
          <div class="col-md-4 mb-3">
            <div class="card action-card p-3 text-center">
              <i class="bi bi-credit-card-2-front display-5 text-warning"></i>
              <h6 class="mt-2">Cards</h6>
              <p class="small text-secondary">View or request debit cards</p>
            </div>
          </div>
          <div class="col-md-4 mb-3">
            <div class="card action-card p-3 text-center">
              <i class="bi bi-cash-coin display-5 text-success"></i>
              <h6 class="mt-2">Apply Loan</h6>
              <p class="small text-secondary">Request and track loans</p>
            </div>
          </div>
        </div>
      </div>

      <!-- Transaction History -->
      <div class="card p-4">
        <h5 class="mb-3 text-gradient">Transactions</h5>
        <div class="table-responsive">
          <table class="table table-borderless align-middle">
            <thead>
              <tr>
                <th>Date</th><th>Description</th><th>Type</th><th>Amount</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>Oct 20, 2025</td><td>Transfer to Jane</td><td><span class="badge bg-danger">Debit</span></td><td>- ₦20,000</td>
              </tr>
              <tr>
                <td>Oct 19, 2025</td><td>Deposit</td><td><span class="badge bg-success">Credit</span></td><td>₦100,000</td>
              </tr>
              <tr>
                <td>Oct 18, 2025</td><td>Loan Payment</td><td><span class="badge bg-danger">Debit</span></td><td>- ₦15,000</td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>



<?php include('includes/footer.php');?>