<?php include('includes/header.php'); ?>

<!-- DASHBOARD MAIN -->
<div class="container pt-4 pb-5">

  <!-- Profile + Greeting -->
  <div class="d-flex justify-content-between align-items-center mb-3">
    <div>
      <h5 class="fw-bold">Hello, <?= htmlspecialchars($userData['firstname']); ?></h5>
      
      <small class="text-muted">Welcome back</small>
    </div>
    <img src="uploads/<?= $userData['photo'] ?: 'default.png'; ?>" 
       class="rounded-circle shadow" width="80" height="80" style="object-fit: cover;">
  </div>
  
  <div class="profile-info mb-4">
        <p style="text-align: left;"><strong>Last Login:</strong> <?php echo $last_login; ?></p>
        <p style="text-align: left;"><strong>IP Address:</strong> <?php echo $last_ip; ?></p>
        <!--<p style="text-align: left;"><strong>Device:</strong> <?php echo $device; ?></p>-->

      </div>

  <!-- Balance Card -->
  <div class="card mb-4 bg-success bg-opacity-25">
    <div class="d-flex justify-content-between align-items-center">
      <small class="">Available Balance</small>
      <button id="toggleBalance" class="btn btn-outline-success btn-sm">
            <i class="bi bi-eye-slash"></i> Hide
          </button>
    </div>
    <h2 class="mt-2 balance"><?= $userData['currency']; ?><?= number_format($userData['account_balance'],2); ?></h2>
    <small class=""><b>Account: <?= $userData['account_number']; ?>(<?= $userData['account_type']; ?>)</b></small>
  </div>
  
  <!--<div class="card p-4 mb-4">-->
  <!--      <div class="row">-->
  <!--        <div class="col-sm-12 mb-3">-->
  <!--          <div class="card p-3 text-center bg-success bg-opacity-25">-->
  <!--            <h6>Account Balance</h6>-->
  <!--            <h3 class="balance">₦450,000</h3>-->
  <!--          </div>-->
  <!--        </div>-->
  <!--        <div class="col-sm-6 mb-3">-->
  <!--          <div class="card p-3 text-center bg-danger bg-opacity-25">-->
  <!--            <h6>Last Debit</h6>-->
  <!--            <h3 class="balance">₦20,000</h3>-->
  <!--          </div>-->
  <!--        </div>-->
  <!--        <div class="col-sm-6 mb-3">-->
  <!--          <div class="card p-3 text-center bg-success bg-opacity-25">-->
  <!--            <h6>Last Credit</h6>-->
  <!--            <h3 class="balance">₦100,000</h3>-->
  <!--          </div>-->
  <!--        </div>-->
  <!--      </div>-->
  <!--    </div>-->

  <!-- Quick Actions -->
  <center><div class="row g-3 mb-4">
    <div class="col-4">
        <a href="transfer">
      <div class="action-btn">
        <i class="bi bi-arrow-left-right"></i>
      </div>
      </a>
      <small>Transfer</small>
      
    </div>
    

    <!--<div class="col-3">-->
    <!--  <div class="action-btn">-->
    <!--    <i class="bi bi-user"></i>-->
    <!--  </div>-->
    <!--  <small>Deposit</small>-->
    <!--</div>-->

    <div class="col-4">
        <a href="card_request">
      <div class="action-btn">
        <i class="bi bi-credit-card-2-back"></i>
      </div>
      </a>
      <small>Cards</small>
    </div>

    <div class="col-4">
        <a href="loan">
      <div class="action-btn">
        <i class="bi bi-cash-coin"></i>
      </div>
      </a>
      <small>Loans</small>
    </div>
  </div></center>
  
  
  <?php
$cardNumber = $userData['card_number'] ?? null;
$cardStatus = $userData['card_status'] ?? 'None';

function maskCard($number) {
    if (!$number) return "**** **** **** ****";
    return substr($number, 0, 4) . " **** **** " . substr($number, -4);
}
?>
<style>
.card-animated {
  transition: transform 0.7s ease, box-shadow 0.7s ease;
  transform-style: preserve-3d;
}
.card-animated:hover {
  transform: scale(1.03) rotateX(5deg) rotateY(5deg);
  box-shadow: 0px 10px 35px rgba(0,0,0,0.25);
}
</style>

<div class="card mb-4 bg-opacity-25">

  <div class="d-flex justify-content-between">
    <strong style="font-size: 18px;">BMELLON Global BANK</strong>
    <img src="assets/images/chip.png" width="45">
  </div>

  <div class="mt-4" style="font-size: 22px; letter-spacing: 3px;">
    <?= maskCard($cardNumber) ?>
  </div>

  <div class="mt-3">
    <small>CARD HOLDER</small><br>
    <strong style="font-size: 17px;">
      <?= htmlspecialchars($userData['firstname'] . ' ' . $userData['lastname']) ?>
    </strong>
  </div>

  <div class="mt-3">
    <small>STATUS</small><br>
    <span class="badge 
      <?php 
        if ($cardStatus === 'Approved') echo 'bg-success'; 
        elseif ($cardStatus === 'Frozen') echo 'bg-danger';
        elseif ($cardStatus === 'Shipped') echo 'bg-info';
        elseif ($cardStatus === 'Delivered') echo 'bg-primary';
        else echo 'bg-warning text-dark';
      ?>
    ">
      <?= $cardStatus ?>
    </span>
  </div>

</div>

   

        <h5 class="mb-3 text-gradient">Transactions <a href="transactions"><span style="float: right;">View</span></a></h5>
        <?php 

if (!isset($_SESSION['user_id'])) {
    header("Location: login");
    exit;
}

$user_id = $_SESSION['user_id'];

$stmt = $pdo->prepare("SELECT * FROM transactions WHERE user_id = ? ORDER BY id DESC LIMIT 20");
$stmt->execute([$user_id]);
$transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
  <!-- Transaction History -->
      <div class="card p-4">
        <?php if (count($transactions) < 1): ?>
    <div class="alert alert-info text-center">
      No transactions yet.
    </div>
  <?php endif; ?>

  <div class="list-group">

    <?php foreach ($transactions as $t): ?>
      
      <div class="list-group-item border-0 border-bottom py-3 d-flex align-items-center justify-content-between">
        
        <div class="d-flex align-items-center">

          <!-- Icon Circle -->
          <div class="rounded-circle me-3 d-flex align-items-center justify-content-center" 
            style="width:45px; height:45px; 
            background: <?= $t['type'] === 'credit' || $t['type'] === 'deposit' ? '#e6f9f0' : '#ffe8e8' ?>;
            color: <?= $t['type'] === 'credit' || $t['type'] === 'deposit' ? '#0a8f46' : '#c71f1f' ?>;">
            
            <i class="bi <?= $t['type'] === 'credit' || $t['type'] === 'deposit' ? 'bi-arrow-down-circle' : 'bi-arrow-up-circle' ?> fs-5"></i>
          </div>

          <div>
            <div class="fw-bold"><?= htmlspecialchars($t['description']) ?></div>
            <small class="text-muted"><?= date("M d, Y • h:i A", strtotime($t['created_at'])) ?></small>
          </div>

        </div>
        
        
        <!-- Amount -->
        <div class="text-end fw-bold" 
          style="color: <?= $t['type'] === 'credit' || $t['type'] === 'deposit' ? '#0a8f46' : '#c71f1f' ?>;">
            
            <span class="badge 
      <?php 
        if ($t['status'] === 'successful') echo 'bg-success'; 
        elseif ($t['status'] === 'pending') echo 'bg-warning';
        elseif ($t['status'] === 'reversed') echo 'bg-primary';
        else echo 'bg-warning text-dark';
      ?>
    ">
      <?= $t['status'] ?>
    </span>
            
          <?= $t['type'] === 'credit' || $t['type'] === 'deposit' ? '+' : '-' ?><?= $userData['currency'] ?><?= number_format($t['amount'], 2) ?>
        </div>

      </div>

    <?php endforeach; ?>

  </div>

</div>



<?php include('includes/footer.php'); ?>
