<?php
session_start();
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../../includes/mail.php';

// ✅ Redirect to login if user not logged in
if (empty($_SESSION['user_id'])) {
    header("Location: /../login");
    exit;
}

// ✅ Fetch user info safely
$stmt = $pdo->prepare("
    SELECT *
    FROM users
    WHERE id = ?
");
$stmt->execute([$_SESSION['user_id']]);
$userData = $stmt->fetch(PDO::FETCH_ASSOC);

// ✅ Prevent crash if user not found or session invalid
if (!$userData) {
    session_destroy();
    header("Location: /login");
    exit;
}

// ✅ Check verification status
if ($userData['is_verified'] == 0 || strtolower($userData['status']) == 'pending') {
    echo "
    <!doctype html>
    <html lang='en'>
    <head>
      <meta charset='utf-8'>
      <meta name='viewport' content='width=device-width, initial-scale=1'>
      <title>Account Pending Verification - BmellonIntl</title>
      <link href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css' rel='stylesheet'>
    </head>
    <body class='bg-light d-flex align-items-center justify-content-center vh-100'>
      <div class='card shadow-lg p-4 text-center' style='max-width:400px;'>
        <h4 class='text-danger mb-3'>Account Suspended</h4>
        <p>Hello <b>".htmlspecialchars($userData['firstname'])."</b>, your account is currently restricted by our technical unit. Please contact the customer service department for more information.</p>
        <p class='text-muted small'>If you think this issue has to do with email verification, please check your email to verify or wait while until this issue is resoved.</p>
        <a href='logout' class='btn btn-primary w-100 mt-3'>Logout</a>
      </div>
    </body>
    </html>
    ";
    exit;
}

// ✅ Sanitize output values to avoid HTML injection
$fullname           = htmlspecialchars($userData['fullname'] ?? 'N/A');
$email              = htmlspecialchars($userData['email'] ?? 'N/A');
$account_number     = htmlspecialchars($userData['account_number'] ?? 'N/A');
$user_account_type  = htmlspecialchars($userData['account_type'] ?? 'N/A');
$last_ip            = htmlspecialchars($userData['last_ip'] ?? 'Unknown');
$last_login         = htmlspecialchars($userData['last_login'] ?? 'N/A');
$current_login      = htmlspecialchars($userData['current_login'] ?? 'N/A');
$device             = htmlspecialchars($userData['device'] ?? 'Unknown Device');
?>






<?php
$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT COUNT(*) AS unread FROM notifications WHERE user_id = ? AND is_read = 0");
$stmt->execute([$user_id]);
$unread = $stmt->fetch(PDO::FETCH_ASSOC)['unread'];
?>






<?php
$user_id = $_SESSION['user_id'] ?? 0;
$stmt = $pdo->prepare("SELECT COUNT(*) AS unread FROM notifications WHERE user_id = ? AND is_read = 0");
$stmt->execute([$user_id]);
$unread = (int)$stmt->fetch(PDO::FETCH_ASSOC)['unread'];
?>

<script>
window.unreadNotifications = <?php echo $unread; ?>;
</script>

<audio id="notifySound" preload="auto">
  <source src="sounds/ping.mp3" type="audio/mp3">
</audio>

<script src="notify.js"></script>






<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>User Dashboard - BmellonIntl</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    :root {
      --bg-color: linear-gradient(135deg, #0f2027, #203a43, #2c5364);
      --card-bg: rgba(255, 255, 255, 0.08);
      --text-color: #fff;
    }

    body.light-mode {
      --bg-color: #f5f6fa;
      --card-bg: #fff;
      --text-color: #222;
    }

    body.light-mode a {
      color: #000;
    }

    body.light-mode a:hover {
      color: #bbb;
    }

    body {
      background: var(--bg-color);
      color: var(--text-color);
      min-height: 100vh;
      font-family: 'Poppins', sans-serif;
      overflow-x: hidden;
      transition: all 0.5s ease-in-out;
    }

    .navbar {
      background: rgba(0, 0, 0, 0.6);
      backdrop-filter: blur(12px);
      transition: background .3s ease;
    }

    body.light-mode .navbar {
      background: rgba(255, 255, 255, 0.8);
    }

    body.light-mode .navbar .active {
      color: #00b4d8;
    }

    body.light-mode .profile-info {
      background: var(--card-bg);
      border: none;
      border-radius: 1rem;
      box-shadow: 0 4px 20px rgba(0, 0, 0, 0.25);
      transition: all .3s ease;
    }

    .navbar-brand {
      font-weight: 600;
      letter-spacing: 1px;
      color: var(--text-color) !important;
    }

    .card {
      background: var(--card-bg);
      border: none;
      border-radius: 1rem;
      box-shadow: 0 4px 20px rgba(0, 0, 0, 0.25);
      transition: all .3s ease;
      color: #fff;
      padding: 20px;
    }

    body.light-mode .card {
      color: #000;
    }

    body.light-mode .navbar .active {
      color: #00b4d8;
    }

    .card:hover {
      transform: translateY(-5px);
    }

    .profile-info {
      background: rgba(255, 255, 255, 0.05);
      border-radius: 10px;
      padding: 1.2rem;
      text-align: center;
    }

    .profile-info img {
      width: 75px;
      height: 75px;
      border-radius: 50%;
      border: 2px solid #00b4d8;
    }

    .text-gradient {
      background: linear-gradient(90deg, #00b4d8, #48cae4);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
    }

    .action-card {
      cursor: pointer;
      transition: transform .3s ease;
    }

    .action-card:hover {
      transform: scale(1.05);
      background: rgba(0, 180, 216, 0.15);
    }

    .bottom-nav {
      position: fixed;
      bottom: 0;
      left: 0;
      width: 100%;
      background: rgba(0, 0, 0, 0.9);
      backdrop-filter: blur(8px);
      display: flex;
      justify-content: space-around;
      padding: .6rem 0;
      z-index: 1000;
    }

    .bottom-nav a {
      color: #bbb;
      text-align: center;
      font-size: 1.3rem;
      text-decoration: none;
    }

    .bottom-nav a.active {
      color: #00b4d8;
    }

    body.light-mode .bottom-nav {
      background: rgba(255, 255, 255, 0.9);
    }

    @media (min-width: 769px) {
      .bottom-nav { display: none; }
    }

    table {
      color: var(--text-color);
    }

    /* === Floating Theme Toggle Button === */
    .theme-toggle {
      position: fixed;
      top: 50%;
      right: 20px;
      transform: translateY(-50%);
      background: #00b4d8;
      color: white;
      border-radius: 50%;
      width: 48px;
      height: 48px;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 1.5rem;
      box-shadow: 0 4px 15px rgba(0,0,0,0.3);
      cursor: pointer;
      z-index: 1100;
      transition: all .3s ease;
    }

    .theme-toggle:hover {
      background: #0077b6;
    }

    body.light-mode .theme-toggle {
      background: #203a43;
      color: #fff;
    }

    .dmodal{
      background: linear-gradient(135deg, #0f2027, #203a43, #2c5364);
    }

    body.light-mode .dmodal {
      background: #fff;
      color: #000;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    .balance-card {
  /*background: linear-gradient(135deg, #0072ff, #00c6ff);*/
  padding: 20px;
  border-radius: 18px;
  color: white;
  
  
  
  background: var(--card-bg);
      border: none;
      border-radius: 1rem;
      box-shadow: 0 4px 20px rgba(0, 0, 0, 0.25);
      transition: all .3s ease;
      color: #fff;
}

.action-btn {
  width: 55px;
  height: 55px;
  background: #f0f4ff;
  border-radius: 14px;
  display: flex;
  justify-content: center;
  align-items: center;
  font-size: 22px;
  color: #000;
}

.transaction-item {
  display: flex;
  justify-content: space-between;
  align-items: center;
}

/* Floating Button */
.floating-btn {
  position: fixed;
  bottom: 20px;
  right: 20px;
  background: #0072ff;
  color: white;
  border: none;
  border-radius: 50%;
  width: 58px;
  height: 58px;
  display: flex;
  justify-content: center;
  align-items: center;
  box-shadow: 0px 4px 10px rgba(0,0,0,.25);
  z-index: 999;
}

/* Slide Menu */
.slide-menu {
  position: fixed;
  bottom: -100%;
  left: 0;
  width: 100%;
  background: #1a1f2b;
  color: white;
  padding: 20px;
  border-top-left-radius: 25px;
  border-top-right-radius: 25px;
  transition: .35s;
  z-index: 1000;
}
.slide-menu.show { bottom: 0; }

.menu-overlay {
  position: fixed; inset: 0; background: rgba(0,0,0,.5); display: none; z-index: 900;
}
.menu-overlay.show { display: block; }

.menu-item { color:white; text-decoration:none; }
.menu-item i { font-size:24px; display:block; }









  </style>
</head>
<body>








<?php
$user_id = $_SESSION['user_id'] ?? 0;
$stmt = $pdo->prepare("SELECT COUNT(*) AS unread FROM notifications WHERE user_id = ? AND is_read = 0");
$stmt->execute([$user_id]);
$unread = (int)$stmt->fetch(PDO::FETCH_ASSOC)['unread'];
?>

<script>
window.unreadNotifications = <?php echo $unread; ?>;
</script>

<audio id="notifySound" preload="auto">
  <source src="../includes/sounds/ping.mp3" type="audio/mp3">
</audio>

<script src="../includes/notify.js"></script>








<!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-dark px-3">
  <a class="navbar-brand" href="../"><img src="../assets/img/logo.png" alt="Bank Logo" width="80"></a>
  <button class="navbar-toggler border-0" type="button" data-bs-toggle="collapse" data-bs-target="#navMenu">
    <i class="bi bi-list btoggler fs-3" style="color:#00b4d8;"></i>
  </button>
  <div class="collapse navbar-collapse" id="navMenu">
    <ul class="navbar-nav ms-auto">
        <?php if($userData['is_admin']== 1): ?>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
        <li class="nav-item"><a class="nav-link" href="../control"><i class="fa fa-tachometer" aria-hidden="true"></i> cPanel</a></li>
        <?php endif;?>
      <li class="nav-item"><a class="nav-link active" href=".">Dashboard</a></li>
      <li class="nav-item"><a class="nav-link" href="transactions">Transactions</a></li>
      <li class="nav-item"><a class="nav-link" href="card_request">Cards</a></li>
      <li class="nav-item"><a class="nav-link" href="loan">Loans</a></li>
      <li class="nav-item"><a class="nav-link" href="settings">Settings</a></li>
      
      <!--<li class="nav-item"><a class="nav-link" href="notifications">🔔 Notifications <?php if($unread > 0) echo "<span class='badge bg-danger'>$unread</span>"; ?></a></li>-->
      
      <li class="nav-item ms-lg-3 mt-2 mt-lg-0 logout-trigger" id="logoutBtn">
            <a class="nav-link" href="#"><i class="bi bi-box-arrow-right me-1"></i> Logout</a>
      </li>
    </ul>
  </div>
</nav>


