<?php include('includes/header.php'); ?>

<!-- DASHBOARD MAIN -->
<div class="container pt-4 pb-5">

  <!-- Profile + Greeting -->
  <div class="d-flex justify-content-between align-items-center mb-3">
    <div>
      <h5 class="fw-bold">Hello, <?= htmlspecialchars($userData['firstname']); ?></h5>
      
      <small class="text-muted">Welcome back</small>
    </div>
    <img src="uploads/<?= $userData['photo'] ?: 'default.png'; ?>" 
       class="rounded-circle shadow" width="80" height="80" style="object-fit: cover;">
  </div>
  
  <div class="profile-info mb-4">
        <p style="text-align: left;"><strong>Last Login:</strong> <?php echo $last_login; ?></p>
        <p style="text-align: left;"><strong>IP Address:</strong> <?php echo $last_ip; ?></p>
        <!--<p style="text-align: left;"><strong>Device:</strong> <?php echo $device; ?></p>-->

      </div>

  <!-- Balance Card -->
  <div class="card mb-4 bg-success bg-opacity-25">
    <div class="d-flex justify-content-between align-items-center">
      <small class="">Available Balance</small>
      <button id="toggleBalance" class="btn btn-outline-success btn-sm">
            <i class="bi bi-eye-slash"></i> Hide
          </button>
    </div>
    <h2 class="mt-2 balance"><?= $userData['currency']; ?><?= number_format($userData['account_balance'],2); ?></h2>
    <small class=""><b>Account: <?= $userData['account_number']; ?>(<?= $userData['account_type']; ?>)</b></small>
  </div>
  
  <!--<div class="card p-4 mb-4">-->
  <!--      <div class="row">-->
  <!--        <div class="col-sm-12 mb-3">-->
  <!--          <div class="card p-3 text-center bg-success bg-opacity-25">-->
  <!--            <h6>Account Balance</h6>-->
  <!--            <h3 class="balance">₦450,000</h3>-->
  <!--          </div>-->
  <!--        </div>-->
  <!--        <div class="col-sm-6 mb-3">-->
  <!--          <div class="card p-3 text-center bg-danger bg-opacity-25">-->
  <!--            <h6>Last Debit</h6>-->
  <!--            <h3 class="balance">₦20,000</h3>-->
  <!--          </div>-->
  <!--        </div>-->
  <!--        <div class="col-sm-6 mb-3">-->
  <!--          <div class="card p-3 text-center bg-success bg-opacity-25">-->
  <!--            <h6>Last Credit</h6>-->
  <!--            <h3 class="balance">₦100,000</h3>-->
  <!--          </div>-->
  <!--        </div>-->
  <!--      </div>-->
  <!--    </div>-->

  <!-- Quick Actions -->
  <center><div class="row g-3 mb-4">
    <div class="col-4">
        <a href="transfer">
      <div class="action-btn">
        <i class="bi bi-arrow-left-right"></i>
      </div>
      </a>
      <small>Transfer</small>
      
    </div>
    

    <!--<div class="col-3">-->
    <!--  <div class="action-btn">-->
    <!--    <i class="bi bi-user"></i>-->
    <!--  </div>-->
    <!--  <small>Deposit</small>-->
    <!--</div>-->

    <div class="col-4">
        <a href="cards">
      <div class="action-btn">
        <i class="bi bi-credit-card-2-back"></i>
      </div>
      </a>
      <small>Cards</small>
    </div>

    <div class="col-4">
        <a href="loan">
      <div class="action-btn">
        <i class="bi bi-cash-coin"></i>
      </div>
      </a>
      <small>Loans</small>
    </div>
  </div></center>
  
  
  <?php
$cardNumber = $userData['card_number'] ?? null;
$cardStatus = $userData['card_status'] ?? 'None';

function maskCard($number) {
    if (!$number) return "**** **** **** ****";
    return substr($number, 0, 4) . " **** **** " . substr($number, -4);
}
?>
<style>
.card-animated {
  transition: transform 0.7s ease, box-shadow 0.7s ease;
  transform-style: preserve-3d;
}
.card-animated:hover {
  transform: scale(1.03) rotateX(5deg) rotateY(5deg);
  box-shadow: 0px 10px 35px rgba(0,0,0,0.25);
}
</style>

<div class="card mb-4 bg-opacity-25">

  <div class="d-flex justify-content-between">
    <strong style="font-size: 18px;">BMELLON INTL BANK</strong>
    <img src="assets/images/chip.png" width="45">
  </div>

  <div class="mt-4" style="font-size: 22px; letter-spacing: 3px;">
    <?= maskCard($cardNumber) ?>
  </div>

  <div class="mt-3">
    <small>CARD HOLDER</small><br>
    <strong style="font-size: 17px;">
      <?= htmlspecialchars($userData['firstname'] . ' ' . $userData['lastname']) ?>
    </strong>
  </div>

  <div class="mt-3">
    <small>STATUS</small><br>
    <span class="badge 
      <.?php 
        if ($cardStatus === 'Approved') echo 'bg-success'; 
        elseif ($cardStatus === 'Frozen') echo 'bg-danger';
        elseif ($cardStatus === 'Shipped') echo 'bg-info';
        elseif ($cardStatus === 'Delivered') echo 'bg-primary';
        else echo 'bg-warning text-dark';
      ?>
    ">
      <?= $cardStatus ?>
    </span>
  </div>

</div>

   
  
  <!-- Transaction History -->
      <div class="card p-4">
        <h5 class="mb-3 text-gradient">Transactions</h5>
        <div class="table-responsive">
          <table class="table table-borderless align-middle">
            <thead>
              <tr>
                <th>Date</th><th>Description</th><th>Type</th><th>Amount</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>Oct 20, 2025</td><td>Transfer to Jane</td><td><span class="badge bg-danger">Debit</span></td><td>- â‚¦20,000</td>
              </tr>
              <tr>
                <td>Oct 19, 2025</td><td>Deposit</td><td><span class="badge bg-success">Credit</span></td><td>â‚¦100,000</td>
              </tr>
              <tr>
                <td>Oct 18, 2025</td><td>Loan Payment</td><td><span class="badge bg-danger">Debit</span></td><td>- â‚¦15,000</td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>

</div>



<?php include('includes/footer.php'); ?>
