<?php 
include 'includes/header.php'; 

if (!isset($_SESSION['user_id'])) {
    header("Location: login");
    exit;
}
?>

<div class="container py-4">
  
  <h4 class="fw-bold mb-3">Change Transaction PIN</h4>

  <?php if (isset($_GET['success'])): ?>
    <div class="alert alert-success"><?= htmlspecialchars($_GET['success']) ?></div>
  <?php endif; ?>

  <?php if (isset($_GET['error'])): ?>
    <div class="alert alert-danger"><?= htmlspecialchars($_GET['error']) ?></div>
  <?php endif; ?>

  <div class="card p-4 shadow-sm border-0">

    <form action="../actions/change_pin_action" method="POST">

      <div class="mb-3">
        <label class="form-label">Current PIN</label>
        <input type="password" name="current_pin" class="form-control" required maxlength="4" minlength="4">
      </div>

      <div class="mb-3">
        <label class="form-label">New PIN</label>
        <input type="password" name="new_pin" class="form-control" required maxlength="4" minlength="4">
      </div>

      <div class="mb-3">
        <label class="form-label">Confirm New PIN</label>
        <input type="password" name="confirm_pin" class="form-control" required maxlength="4" minlength="4">
      </div>

      <button class="btn btn-primary w-100">Update PIN</button>
    </form>
  </div>

</div>

<?php include 'includes/footer.php'; ?>
