<?php 
include 'includes/header.php'; 

if (!isset($_SESSION['user_id'])) {
    header("Location: login");
    exit;
}
?>

<div class="container py-4">

  <div class="card p-4 shadow-sm border-0">

    <h4 class="fw-bold mb-3 text-gradient">Change Password</h4>

    <form action="../actions/change_password" method="POST">
        
        <?php if (isset($_GET['success'])): ?>
      <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?= htmlspecialchars($_GET['success']); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      </div>
    <?php endif; ?>

    <?php if (isset($_GET['error'])): ?>
      <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?= htmlspecialchars($_GET['error']); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
      </div>
    <?php endif; ?>

      <div class="mb-3">
        <label class="form-label">Current Password</label>
        <input type="password" name="current_password" class="form-control" required>
      </div>

      <div class="mb-3">
        <label class="form-label">New Password</label>
        <input type="password" name="new_password" class="form-control" minlength="6" required>
      </div>

      <div class="mb-3">
        <label class="form-label">Confirm New Password</label>
        <input type="password" name="confirm_password" class="form-control" minlength="6" required>
      </div>

      <button class="btn btn-info w-100">Update Password</button>

    </form>

  </div>

</div>

<?php include 'includes/footer.php'; ?>
