<?php include('includes/header.php');?>

<div class="container py-4">
  <div class="card p-4">

    <h4 class="text-gradient mb-3">Request Debit Card</h4>
    <p class="text-muted small">Fill the form below to request your debit card.</p>

    <form action="../actions/send_card_request" method="POST">

      <div class="mb-3">
        <label class="form-label">Full Name</label>
        <input type="text" value="<?= htmlspecialchars($userData['firstname']) ?> <?= htmlspecialchars($userData['lastname']) ?>" class="form-control" readonly>
      </div>

      <div class="mb-3">
        <label class="form-label">Phone Number</label>
        <input type="text" name="phone" value="<?= htmlspecialchars($userData['phone']) ?>" required class="form-control">
      </div>

      <div class="mb-3">
        <label class="form-label">Delivery Address</label>
        <textarea name="address" class="form-control" rows="3" required></textarea>
      </div>

      <div class="mb-3">
        <label class="form-label">Select Card Type</label>
        <select name="card_type" class="form-select" required>
            <option value="">-- Select Card Type --</option>
            <option value="Debit Card">Debit Card</option>
            <option value="MasterCard">MasterCard</option>
            <option value="Visa Card">Visa Card</option>
        </select>
      </div>

      <button class="btn btn-info w-100">Submit Card Request</button>

    </form>
  </div>
</div>

<?php include('includes/footer.php');?>
