<?php include('includes/header.php'); ?>

<?php
$stmt = $pdo->prepare("SELECT * FROM transactions WHERE user_id = ? ORDER BY id DESC LIMIT 50");
$stmt->execute([$_SESSION['user_id']]);
$transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container py-4">

  <a href="dashboard.php" class="text-light fs-4"><i class="bi bi-arrow-left"></i></a>

  <h4 class="mt-2 fw-bold">Bank Account Details</h4>
  <p class="text-muted small mb-4">Your account information</p>

  <!-- Account Info Card -->
  <div class="card p-3 mb-4">

    <div class="d-flex justify-content-between align-items-center mb-2">
      <div>
        <small class="text-muted">Account Name</small><br>
        <strong><?= htmlspecialchars($userData['firstname']." ".$userData['lastname']); ?></strong>
      </div>
      <i class="bi bi-person-circle fs-3 text-primary"></i>
    </div>

    <hr>

    <div class="d-flex justify-content-between align-items-center mb-2">
      <div>
        <small class="text-muted">Account Number</small><br>
        <strong id="acctNumber"><?= $userData['account_number']; ?></strong>
      </div>
      <button class="btn btn-outline-primary btn-sm" onclick="copyAcct()"><i class="bi bi-copy"></i> Copy</button>
    </div>

    <hr>

    <div>
      <small class="text-muted">Bank Name</small><br>
      <strong>BMELLON INTL BANK</strong>
    </div>

  </div>

  <h5 class="fw-bold mb-2">Transaction History</h5>

  <div class="card p-3">

    <?php if (count($transactions) < 1): ?>
      <p class="text-center text-muted mt-3">No transactions yet.</p>
    <?php endif; ?>

    <?php foreach ($transactions as $txn): ?>
      <div class="transaction-item py-2">
        <div>
          <strong><?= htmlspecialchars($txn['description']); ?></strong><br>
          <small class="text-muted"><?= $txn['created_at']; ?></small>
        </div>
        <span class="<?= ($txn['type'] == 'credit') ? 'text-success' : 'text-danger'; ?> fw-bold">
          <?= ($txn['type'] == 'credit') ? '+' : '-'; ?> ₦<?= number_format($txn['amount']); ?>
        </span>
      </div>
      <hr>
    <?php endforeach; ?>

  </div>

</div>

<script>
function copyAcct() {
  navigator.clipboard.writeText(document.getElementById("acctNumber").innerText);
  alert("Account Number Copied!");
}
</script>

<?php include('includes/footer.php'); ?>
