<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Reset Password - Bmellonglobal</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
  <main class="py-5">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-md-5">
          <div class="card shadow-sm">
            <div class="card-body p-4">
              <h4 class="text-primary mb-3">Reset Your Password</h4>

              <div id="response"></div>

              <form id="resetForm">
                <input type="hidden" name="token" value="<?= htmlspecialchars($_GET['token'] ?? '') ?>">
                <div class="mb-3">
                  <label class="form-label">New Password</label>
                  <input type="password" name="password" class="form-control" required minlength="6">
                </div>
                <div class="mb-3">
                  <label class="form-label">Confirm Password</label>
                  <input type="password" name="confirm" class="form-control" required minlength="6">
                </div>
                <button type="submit" class="btn btn-primary w-100">Reset Password</button>
              </form>

              <p class="mt-3 text-center"><a href="login">Back to Login</a></p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </main>

  <script>
    const form = document.getElementById('resetForm');
    const resBox = document.getElementById('response');

    form.addEventListener('submit', async (e) => {
      e.preventDefault();
      resBox.innerHTML = '<div class="alert alert-info">Processing...</div>';

      try {
        const fd = new FormData(form);
        const res = await fetch('/actions/reset_password', {
          method: 'POST',
          body: fd
        });
        const data = await res.json();
        resBox.innerHTML = `<div class="alert alert-${data.status === 'success' ? 'success' : 'danger'}">${data.message}</div>`;
        if (data.status === 'success') form.reset();
      } catch (err) {
        resBox.innerHTML = "<div class='alert alert-danger'>Server error. Please try again later.</div>";
      }
    });
  </script>
</body>
</html>
