<?php
session_start();
// ✅ Redirect to login if user not logged in
if ($_SESSION['user_id']) {
    header("Location: users/");
    exit;
}

?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Login - Bmellonglobal</title>

  <link rel="icon" href="/assets/img/favicon.ico">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
  <main class="py-5">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-md-5">
          <div class="card shadow-sm">
            <div class="card-body p-4">
              <div class="text-center mb-3">
                <img src="assets/img/logo.png" alt="Bmellonglobal" style="width:100px;">
                <h4 class="text-primary mt-2">Login to Your Account</h4>
              </div>

              <div id="loginResponse"></div>

              <form id="loginForm">
                <div class="mb-3">
                  <label class="form-label">Email Address</label>
                  <input type="email" name="email" class="form-control" required>
                </div>
                <div class="mb-3">
                  <label class="form-label">Password</label>
                  <input type="password" name="password" class="form-control" required>
                </div>
                <button type="submit" class="btn btn-primary w-100">Login</button>
              </form>

              <div class="mt-3 text-center">
                <a href="forgot-password">Forgot Password?</a>
              </div>
              <div class="mt-2 text-center">
                Don't have an account? <a href="register">Create one</a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </main>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    const form = document.getElementById('loginForm');
    const responseDiv = document.getElementById('loginResponse');

    form.addEventListener('submit', async (e) => {
      e.preventDefault();

      responseDiv.innerHTML = `<div class="alert alert-info">Checking credentials...</div>`;

      const fd = new FormData(form);
      const res = await fetch('actions/login_action', { method: 'POST', body: fd });
      const data = await res.json();

      if (data.status === 'success') {
        responseDiv.innerHTML = `<div class="alert alert-success">${data.message}</div>`;
        setTimeout(() => location.href = 'users/', 1500);
      } else if (data.status === 'unverified') {
        responseDiv.innerHTML = `
          <div class="alert alert-warning">
            ${data.message}<br>
            <button class="btn btn-sm btn-outline-primary mt-2" id="resendBtn">Resend Verification Email</button>
          </div>`;

        document.getElementById('resendBtn').addEventListener('click', async () => {
          responseDiv.innerHTML = `<div class="alert alert-info">Resending verification email...</div>`;
          const fd2 = new FormData();
          fd2.append('email', data.email);
          const res2 = await fetch('actions/resend-verification', { method: 'POST', body: fd2 });
          const data2 = await res2.json();
          responseDiv.innerHTML = `<div class="alert alert-${data2.status === 'success' ? 'success' : 'danger'}">${data2.message}</div>`;
        });
      } else {
        responseDiv.innerHTML = `<div class="alert alert-danger">${data.message}</div>`;
      }
    });
  </script>
</body>
</html>
