<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Forgot Password - Bmellonglobal</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
  <main class="py-5">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-md-5">
          <div class="card shadow-sm">
            <div class="card-body p-4">
              <h4 class="text-primary mb-3">Forgot Your Password?</h4>
              <p class="text-muted small">Enter your registered email and we’ll send a reset link.</p>

              <div id="response"></div>

              <form id="forgotForm">
                <div class="mb-3">
                  <label class="form-label">Email address</label>
                  <input type="email" name="email" class="form-control" required>
                </div>
                <button type="submit" class="btn btn-primary w-100">Send Reset Link</button>
              </form>

              <p class="mt-3 text-center"><a href="login">Back to Login</a></p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </main>

<script>
const form = document.getElementById('forgotForm');
const resBox = document.getElementById('response');

form.addEventListener('submit', async (e) => {
  e.preventDefault();
  resBox.innerHTML = '<div class="alert alert-info">Processing...</div>';

  try {
    const fd = new FormData(form);
    const res = await fetch('/actions/forgot-password', { method: 'POST', body: fd });
    const data = await res.json();

    resBox.innerHTML = `<div class="alert alert-${data.status === 'success' ? 'success' : 'danger'}">${data.message}</div>`;
    if (data.status === 'success') form.reset();

  } catch (err) {
    console.error(err);
    resBox.innerHTML = "<div class='alert alert-danger'>Server error. Please try again.</div>";
  }
});
</script>
</body>
</html>
