<?php
require_once __DIR__ . '/../actions/admin_auth.php';
require_once __DIR__ . '/../includes/db.php';

// ✅ Fetch all users
$stmt = $pdo->query("
    SELECT id, fullname, email, account_number, account_type, account_balance, is_verified, is_admin, created_at
    FROM users
    ORDER BY id DESC
");
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Admin Dashboard - BmellonIntl</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {
      background: #f5f6fa;
      font-family: 'Poppins', sans-serif;
    }
    .navbar {
      background: #0f2027;
      background: linear-gradient(90deg, #203a43, #2c5364);
    }
    .navbar-brand {
      color: #fff !important;
      font-weight: 600;
    }
    .card {
      border-radius: 1rem;
      box-shadow: 0 2px 15px rgba(0,0,0,0.1);
    }
    .btn-action {
      padding: 3px 10px;
      font-size: 0.85rem;
    }
  </style>
</head>
<body>
<nav class="navbar navbar-dark px-3">
  <a class="navbar-brand" href="#">BmellonIntl Admin</a>
  <div>
    <a href="/logout" class="btn btn-danger btn-sm"><i class="bi bi-box-arrow-right"></i> Logout</a>
  </div>
</nav>

<div class="container py-4">
  <h3 class="mb-4 text-center text-dark fw-bold">Admin Dashboard</h3>

  <div class="card p-3">
    <div class="table-responsive">
      <table class="table table-striped align-middle text-center">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Full Name</th>
            <th>Email</th>
            <th>Account No.</th>
            <th>Type</th>
            <th>Balance (₦)</th>
            <th>Verified</th>
            <th>Admin</th>
            <th>Date</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($users): ?>
            <?php foreach ($users as $i => $user): ?>
              <?php
foreach ($users as $i => $user) {
    // safely handle nulls
    $fullname      = htmlspecialchars((string)($user['fullname'] ?? ''), ENT_QUOTES, 'UTF-8');
    $email         = htmlspecialchars((string)($user['email'] ?? ''), ENT_QUOTES, 'UTF-8');
    $accountNumber = htmlspecialchars((string)($user['account_number'] ?? ''), ENT_QUOTES, 'UTF-8');
    $accountType   = htmlspecialchars((string)($user['account_type'] ?? 'Standard'), ENT_QUOTES, 'UTF-8');
    $createdAt     = htmlspecialchars((string)($user['created_at'] ?? ''), ENT_QUOTES, 'UTF-8');

    // pull dynamic currency (fallback to ₦)
    $currency      = htmlspecialchars((string)($user['currency'] ?? '₦'), ENT_QUOTES, 'UTF-8');

    // handle balance safely
    $balance       = (float)($user['account_balance'] ?? 0);
    $balanceText   = $currency . ' ' . number_format($balance, 2);
    $balanceClass  = $balance > 0 ? 'text-success' : ($balance < 0 ? 'text-danger' : 'text-muted');

    $isVerified    = (int)($user['is_verified'] ?? 0);
    $isAdmin       = (int)($user['is_admin'] ?? 0);
?>
<tr>
    <td><?= $i + 1 ?></td>
    <td><?= $fullname ?></td>
    <td><?= $email ?></td>
    <td><?= $accountNumber ?></td>
    <td><?= $accountType ?></td>
    <td class="<?= $balanceClass ?>"><?= htmlspecialchars($balanceText, ENT_QUOTES, 'UTF-8') ?></td>
    <td>
        <?= $isVerified ? '<span class="badge bg-success">Verified</span>' : '<span class="badge bg-danger">Unverified</span>' ?>
    </td>
    <td>
        <?= $isAdmin ? '<span class="badge bg-primary">Admin</span>' : '<span class="badge bg-secondary">User</span>' ?>
    </td>
    <td><?= $createdAt ?></td>
    <td>
        <a href="verify_user.php?id=<?= (int)$user['id'] ?>" class="btn btn-success btn-action btn-sm">Verify</a>
        <a href="fund_user.php?id=<?= (int)$user['id'] ?>" class="btn btn-warning btn-action btn-sm">Fund</a>
        <a href="deduct_user.php?id=<?= (int)$user['id'] ?>" class="btn btn-danger btn-action btn-sm">Deduct</a>
    </td>
</tr>
<?php } ?>

            <?php endforeach; ?>
          <?php else: ?>
            <tr><td colspan="10">No users found.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
</body>
</html>
