<?php
require_once __DIR__ . '/../actions/admin_auth.php'; // restrict access to admins
require_once __DIR__ . '/../includes/db.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Fund User Account - Admin | BmellonIntl</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container py-5">
  <h3 class="mb-4 text-center text-primary">Fund User Account</h3>

  <div class="card shadow p-4">
    <form id="fundForm">
      <div class="mb-3">
        <label class="form-label">User Email or Account Number</label>
        <input type="text" name="identifier" class="form-control" required placeholder="Enter user's email or account number">
      </div>

      <div class="mb-3">
        <label class="form-label">Amount (₦)</label>
        <input type="number" name="amount" class="form-control" step="0.01" required min="100">
      </div>

      <div class="mb-3">
        <label class="form-label">Description (optional)</label>
        <input type="text" name="description" class="form-control" placeholder="e.g. Manual funding, bonus, correction...">
      </div>

      <button type="submit" class="btn btn-primary w-100">Credit User</button>
    </form>

    <div id="fundResponse" class="mt-3"></div>
  </div>
</div>

<script>
  const form = document.getElementById('fundForm');
  form.addEventListener('submit', async (e) => {
    e.preventDefault();
    const fd = new FormData(form);
    const el = document.getElementById('fundResponse');
    el.innerHTML = '<div class="alert alert-info">Processing...</div>';
    
    const res = await fetch('../actions/fund_user_action', { method: 'POST', body: fd });
    const data = await res.json();
    if (data.status === 'success') {
      el.innerHTML = `<div class="alert alert-success">${data.message}</div>`;
      form.reset();
    } else {
      el.innerHTML = `<div class="alert alert-danger">${data.message}</div>`;
    }
  });
</script>

</body>
</html>
