<?php
require_once __DIR__ . '/../actions/admin_auth.php';
require_once __DIR__ . '/../includes/db.php';

if (empty($_GET['id'])) {
  header("Location: users");
  exit;
}

$user_id = (int) $_GET['id'];

// ✅ Fetch user info
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
  die("User not found.");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $firstname = trim($_POST['firstname']);
  $lastname = trim($_POST['lastname']);
  $email = trim($_POST['email']);
  $phone = trim($_POST['phone']);
  $address = trim($_POST['address']);
  $gender = trim($_POST['gender']);
  $dob = trim($_POST['dob']);
  $account_number = trim($_POST['account_number']);
  $account_type = trim($_POST['account_type']);
  $currency = trim($_POST['currency']);
  $account_balance = floatval($_POST['account_balance']);
  $is_verified = isset($_POST['is_verified']) ? 1 : 0;
  $is_active = isset($_POST['is_active']) ? 1 : 0;
  $transfer_pin = trim($_POST['transfer_pin']);
  $new_password = trim($_POST['new_password']);

  // ✅ Update base user info
  $sql = "UPDATE users 
          SET firstname=?, lastname=?, email=?, phone=?, address=?, gender=?, dob=?, 
              account_number=?, account_type=?, currency=?, account_balance=?, 
              is_verified=?, is_active=?";
  $params = [$firstname, $lastname, $email, $phone, $address, $gender, $dob, 
             $account_number, $account_type, $currency, $account_balance, 
             $is_verified, $is_active];

  // ✅ Optional updates
  if (!empty($transfer_pin)) {
    $sql .= ", transfer_pin=?";
    $params[] = password_hash($transfer_pin, PASSWORD_DEFAULT);
  }

  if (!empty($new_password)) {
    $sql .= ", password=?";
    $params[] = password_hash($new_password, PASSWORD_DEFAULT);
  }

  $sql .= " WHERE id=?";
  $params[] = $user_id;

  $stmt = $pdo->prepare($sql);
  $stmt->execute($params);

  $success = "✅ User details updated successfully.";

  // Refresh data
  $stmt = $pdo->prepare("SELECT * FROM users WHERE id=?");
  $stmt->execute([$user_id]);
  $user = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Edit User - Admin Control</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container py-5">
  <div class="card shadow-sm">
    <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
      <h4 class="mb-0">Edit User: <?= htmlspecialchars($user['firstname'] . ' ' . $user['lastname']) ?></h4>
      <a href="users" class="btn btn-light btn-sm">← Back to Users</a>
    </div>

    <div class="card-body">
      <?php if (!empty($success)): ?>
        <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
      <?php endif; ?>

      <form method="POST" class="row g-3">

        <div class="col-md-6">
          <label class="form-label">First Name</label>
          <input type="text" name="firstname" class="form-control" 
                 value="<?= htmlspecialchars($user['firstname']) ?>" required>
        </div>

        <div class="col-md-6">
          <label class="form-label">Last Name</label>
          <input type="text" name="lastname" class="form-control" 
                 value="<?= htmlspecialchars($user['lastname']) ?>" required>
        </div>

        <div class="col-md-6">
          <label class="form-label">Email</label>
          <input type="email" name="email" class="form-control" 
                 value="<?= htmlspecialchars($user['email']) ?>" required>
        </div>

        <div class="col-md-6">
          <label class="form-label">Phone</label>
          <input type="text" name="phone" class="form-control" 
                 value="<?= htmlspecialchars($user['phone'] ?? '') ?>">
        </div>

        <div class="col-md-6">
          <label class="form-label">Address</label>
          <input type="text" name="address" class="form-control" 
                 value="<?= htmlspecialchars($user['address'] ?? '') ?>">
        </div>

        <div class="col-md-3">
          <label class="form-label">Gender</label>
          <select name="gender" class="form-select">
            <option value="">-- Select --</option>
            <option value="Male" <?= $user['gender'] == 'Male' ? 'selected' : '' ?>>Male</option>
            <option value="Female" <?= $user['gender'] == 'Female' ? 'selected' : '' ?>>Female</option>
          </select>
        </div>

        <div class="col-md-3">
          <label class="form-label">Date of Birth</label>
          <input type="date" name="dob" class="form-control" 
                 value="<?= htmlspecialchars($user['dob'] ?? '') ?>">
        </div>

        <div class="col-md-4">
          <label class="form-label">Account Number</label>
          <input type="text" name="account_number" class="form-control" 
                 value="<?= htmlspecialchars($user['account_number'] ?? '') ?>">
        </div>

        <div class="col-md-4">
          <label class="form-label">Account Type</label>
          <select name="account_type" class="form-select">
            <option value="Savings" <?= $user['account_type'] == 'Savings' ? 'selected' : '' ?>>Savings</option>
            <option value="Current" <?= $user['account_type'] == 'Current' ? 'selected' : '' ?>>Current</option>
            <option value="Business" <?= $user['account_type'] == 'Business' ? 'selected' : '' ?>>Business</option>
          </select>
        </div>

        <div class="col-md-4">
          <label class="form-label">Currency</label>
          <input type="text" name="currency" class="form-control" 
                 value="<?= htmlspecialchars($user['currency'] ?? '₦') ?>" maxlength="5">
        </div>

        <div class="col-md-4">
          <label class="form-label">Account Balance</label>
          <input type="number" step="0.01" name="account_balance" class="form-control" 
                 value="<?= htmlspecialchars($user['account_balance']) ?>">
        </div>

        <div class="col-md-6">
          <label class="form-label">Reset Transfer PIN</label>
          <input type="password" name="transfer_pin" class="form-control" 
                 placeholder="Leave blank to keep existing PIN">
        </div>

        <div class="col-md-6">
          <label class="form-label">Reset Password</label>
          <input type="password" name="new_password" class="form-control" 
                 placeholder="Leave blank to keep existing password">
        </div>

        <div class="col-md-3 d-flex align-items-center">
          <div class="form-check mt-4">
            <input type="checkbox" name="is_verified" class="form-check-input" id="verifiedCheck" <?= $user['is_verified'] ? 'checked' : '' ?>>
            <label class="form-check-label" for="verifiedCheck">Verified</label>
          </div>
        </div>

        <div class="col-md-3 d-flex align-items-center">
          <div class="form-check mt-4">
            <input type="checkbox" name="is_active" class="form-check-input" id="activeCheck" <?= $user['is_active'] ? 'checked' : '' ?>>
            <label class="form-check-label" for="activeCheck">Active</label>
          </div>
        </div>

        <div class="col-12">
          <button type="submit" class="btn btn-success px-4">💾 Save Changes</button>
        </div>
      </form>
    </div>
  </div>
</div>
 
</body>
</html>
