<?php
// actions/update_user.php
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/admin_auth.php';

header('Content-Type: application/json; charset=utf-8');

try {
    if (empty($_POST['id'])) {
        echo json_encode(['status' => 'error', 'message' => 'User ID is missing.']);
        exit;
    }

    $id = intval($_POST['id']);

    // sanitize inputs
    $firstname = trim((string)($_POST['firstname'] ?? ''));
    $lastname  = trim((string)($_POST['lastname'] ?? ''));
    $email     = trim((string)($_POST['email'] ?? ''));
    $phone     = trim((string)($_POST['phone'] ?? ''));
    $account_number = trim((string)($_POST['account_number'] ?? ''));
    $account_balance = isset($_POST['account_balance']) ? floatval($_POST['account_balance']) : 0.0;
    $currency  = trim((string)($_POST['currency'] ?? ''));
    $transfer_pin = trim((string)($_POST['transfer_pin'] ?? ''));
    $is_verified = isset($_POST['is_verified']) ? intval($_POST['is_verified']) : 0;
    $is_admin = isset($_POST['is_admin']) ? intval($_POST['is_admin']) : 0;

    // Normalize tstatus: accept only 'active' or 'review'
    $raw_status = trim((string)($_POST['a_status'] ?? 'active'));
    $status = ($raw_status === 'pending') ? 'pending' : 'active';
    
    // Normalize tstatus: accept only 'active' or 'review'
    // $raw_tstatus = trim((string)($_POST['tr_status'] ?? 'active'));
    // $tstatus = ($raw_tstatus === 'active') ? 'active' : 'active';
    
    $card_number = trim((string)($_POST['card_number'] ?? ''));
    
    // $raw_card_number = trim((string)($_POST['card_status'] ?? 'Requested'));
    // $cardstatus = ($raw_card_number === 'Requested') ? 'Requested' : 'Approved';
    
    $tstatus = trim((string)($_POST['tr_status'] ?? ''));
    
    $cardstatus     = trim((string)($_POST['card_status'] ?? ''));

    // Normalize auto_reverse: 0 or 1
    $auto_reverse = (isset($_POST['auto_reverse']) && intval($_POST['auto_reverse']) === 1) ? 1 : 0;
    
    // Map front-end card_request to DB has_card (0/1)
    $has_card = (isset($_POST['has_card']) && intval($_POST['has_card']) === 1) ? 1 : 0;
    
    $otp = trim((string)($_POST['otp'] ?? ''));

    if ($firstname === '' || $lastname === '' || $email === '') {
        echo json_encode(['status' => 'error', 'message' => 'Firstname, Lastname, and Email are required.']);
        exit;
    }

    // Correct UPDATE with commas and proper ordering
    $sql = "UPDATE users SET
                firstname = ?,
                lastname = ?,
                email = ?,
                phone = ?,
                account_number = ?,
                account_balance = ?,
                currency = ?,
                transfer_pin = ?,
                is_verified = ?,
                status = ?,
                is_admin = ?,
                has_card = ?,
                auto_reverse = ?,
                
                card_number = ?,
                card_status = ?,
                tstatus = ?,
                otp = ?
            WHERE id = ?";

    $stmt = $pdo->prepare($sql);
    $ok = $stmt->execute([
        $firstname,
        $lastname,
        $email,
        $phone,
        $account_number,
        $account_balance,
        $currency,
        $transfer_pin,
        $is_verified,
        $status,
        $is_admin,
        $has_card,
        $auto_reverse,
        
        $card_number,
        $cardstatus,
        $tstatus,
        $otp,
        $id
    ]);

    if ($ok) {
        echo json_encode(['status' => 'success', 'message' => 'User information updated successfully.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Update failed or no changes made.']);
    }

} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Server error: ' . $e->getMessage()]);
}
