<?php
declare(strict_types=1);
session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/mail.php';

if (empty($_SESSION['user_id'])) {
    die("Unauthorized access.");
}

$user_id = (int)$_SESSION['user_id'];

$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ? LIMIT 1");
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    die("User not found.");
}

$phone       = trim($_POST['phone'] ?? '');
$loan_amount = trim($_POST['loan_amount'] ?? '');
$duration    = trim($_POST['duration'] ?? '');
$purpose     = trim($_POST['purpose'] ?? '');

if ($phone === '' || $loan_amount === '' || $duration === '' || $purpose === '') {
    die("All fields are required.");
}

$firstname = $user['firstname'];
$lastname  = $user['lastname'];
$email     = $user['email'];
$account   = $user['account_number'];

/* ✅ Email to Admin */
sendMail(
  'contact@intlbmellon.com',
  "New Loan Request - {$firstname} {$lastname}",
  '
  <div style="font-family: Arial, sans-serif; max-width: 600px; margin: auto; background: #f5f6fa; padding: 20px; border-radius: 8px;">
      
      <div style="background: linear-gradient(135deg, #1d4350, #a43931); padding: 15px; border-radius: 8px; text-align: center; color: white;">
          <h2 style="margin: 0;">New Loan Request</h2>
      </div>

      <div style="background: #fff; padding: 20px; border-radius: 8px; margin-top: 15px;">
          <h3 style="color: #203a43; margin-bottom: 10px;">User Information</h3>
          
          <p style="margin: 4px 0;"><strong>Name:</strong> '.$firstname.' '.$lastname.'</p>
          <p style="margin: 4px 0;"><strong>Email:</strong> '.$email.'</p>
          <p style="margin: 4px 0;"><strong>Phone:</strong> '.$phone.'</p>
          <p style="margin: 4px 0;"><strong>Account Number:</strong> '.$account.'</p>

          <hr style="margin: 20px 0;">

          <h3 style="color: #203a43; margin-bottom: 10px;">Loan Details</h3>
          <p style="margin: 4px 0;"><strong>Requested Amount:</strong> '.$user['currency'].''.$loan_amount.'</p>
          <p style="margin: 4px 0;"><strong>Repayment Duration:</strong> '.$duration.'</p>
          <p style="margin: 4px 0;"><strong>Purpose:</strong><br> '.$purpose.'</p>

          <p style="margin-top: 20px;">Please review and process this request from the admin dashboard.</p>
      </div>

      <div style="text-align: center; padding: 15px; color: #777; font-size: 13px;">
          Bmellonglobal Bank • Secure Digital Banking
      </div>

  </div>
  '
);


/* ✅ Email to User */
sendMail(
  $email,
  "Your Loan Request Has Been Received",
  '
  <div style="font-family: Arial, sans-serif; max-width: 600px; margin: auto; background: #f5f6fa; padding: 20px; border-radius: 8px;">
      
      <div style="background: #203a43; padding: 15px; border-radius: 8px; text-align: center; color: white;">
          <h2 style="margin: 0;">Loan Request Received</h2>
      </div>

      <div style="background: #fff; padding: 20px; border-radius: 8px; margin-top: 15px;">
          <p>Hello <strong>'.$firstname.'</strong>,</p>

          <p>Your loan request of <strong>'.$user['currency'].''.$loan_amount.'</strong> for a duration of <strong>'.$duration.'</strong> has been successfully submitted.</p>

          <p><strong>Loan Purpose Provided:</strong><br>'.$purpose.'</p>

          <p>Our financial department will review the request and contact you shortly.</p>

          <p style="margin-top:20px;">Thank you for choosing <strong>Bmellonglobal</strong>.</p>
      </div>

      <div style="text-align: center; padding: 15px; color: #777; font-size: 13px;">
          Bmellonglobal Bank • Secure Digital Banking
      </div>

  </div>
  '
);

/* ✅ Redirect */
header("Location: ../loan.php?success=Loan request submitted successfully");
exit;
