<?php
declare(strict_types=1);
session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/mail.php';

if (empty($_SESSION['user_id'])) {
    die("Unauthorized access.");
}

$user_id = (int)$_SESSION['user_id'];

$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ? LIMIT 1");
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    die("User not found.");
}

$phone      = trim($_POST['phone'] ?? '');
$address    = trim($_POST['address'] ?? '');
$card_type  = trim($_POST['card_type'] ?? '');

if ($phone === '' || $address === '' || $card_type === '') {
    die("All fields are required.");
}

$firstname = $user['firstname'];
$lastname = $user['lastname'];
$email = $user['email'];

$mail_sent = sendMail(
  'contact@intlbmellon.com',
  "New Debit Card Request - {$firstname} {$lastname}",
  '
  <div style="font-family: Arial, sans-serif; max-width: 600px; margin: auto; background: #f5f6fa; padding: 20px; border-radius: 8px;">
      
      <div style="background: linear-gradient(135deg, #0f2027, #203a43, #2c5364); padding: 15px; border-radius: 8px; text-align: center; color: white;">
          <h2 style="margin: 0;">New Debit Card Request</h2>
      </div>

      <div style="background: #fff; padding: 20px; border-radius: 8px; margin-top: 15px;">
          <h3 style="color: #203a43; margin-bottom: 10px;">User Information</h3>
          
          <p style="margin: 4px 0;"><strong>Name:</strong> '.$firstname.' '.$lastname.'</p>
          <p style="margin: 4px 0;"><strong>Email:</strong> '.$email.'</p>
          <p style="margin: 4px 0;"><strong>Phone:</strong> '.$phone.'</p>
          <p style="margin: 4px 0;"><strong>Account Number:</strong> '.$user['account_number'].'</p>

          <hr style="margin: 20px 0;">

          <h3 style="color: #203a43; margin-bottom: 10px;">Card Request Details</h3>
          <p style="margin: 4px 0;"><strong>Requested Card Type:</strong> '.$card_type.'</p>
          <p style="margin: 4px 0;"><strong>Delivery Address:</strong><br> '.$address.'</p>

          <p style="margin-top: 20px;">Please review and process this request from the admin dashboard.</p>
      </div>

      <div style="text-align: center; padding: 15px; color: #777; font-size: 13px;">
          Bmellonglobal Bank • Secure Digital Banking
      </div>

  </div>
  '
);




sendMail(
  $email,
  "Your Debit Card Request Has Been Received",
  '
  <div style="font-family: Arial, sans-serif; max-width: 600px; margin: auto; background: #f5f6fa; padding: 20px; border-radius: 8px;">
      
      <div style="background: #203a43; padding: 15px; border-radius: 8px; text-align: center; color: white;">
          <h2 style="margin: 0;">Card Request Received</h2>
      </div>

      <div style="background: #fff; padding: 20px; border-radius: 8px; margin-top: 15px;">
          <p>Hello <strong>'.$firstname.'</strong>,</p>

          <p>Your request for a <strong>'.$card_type.'</strong> has been successfully submitted.</p>

          <p>Our support team will review and contact you shortly regarding the card processing and delivery arrangements.</p>

          <p><strong>Delivery Address Provided:</strong><br>'.$address.'</p>

          <p style="margin-top:20px;">Thank you for choosing <strong>Bmellonglobal</strong>.</p>
      </div>

      <div style="text-align: center; padding: 15px; color: #777; font-size: 13px;">
          Bmellonglobal Bank • Secure Digital Banking
      </div>

  </div>
  '
);



// ✅ Redirect back with success message
header("Location: cards?success=Card request submitted successfully");
exit;
