<?php
// actions/lookup_account.php
// Returns JSON { status: 'success'|'error', fullname: 'Name' }

declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/../includes/db.php';

if (!isset($_POST['account_number'])) {
    echo json_encode(['status'=>'error','message'=>'Account number required.']);
    exit;
}

$acct = trim($_POST['account_number']);
if ($acct === '') {
    echo json_encode(['status'=>'error','message'=>'Account number required.']);
    exit;
}

$stmt = $pdo->prepare("SELECT firstname, lastname, fullname FROM users WHERE account_number = ? LIMIT 1");
$stmt->execute([$acct]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if ($user) {
    $name = trim($user['firstname'].' '.$user['lastname']);
    echo json_encode(['status'=>'success','firstname'=>$name]);
    exit;
}

echo json_encode(['status'=>'error','message'=>'Account not found']);
exit;
