<?php
require_once __DIR__ . '/../actions/admin_auth.php';
require_once __DIR__ . '/../includes/db.php';

header('Content-Type: application/json; charset=utf-8');

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);
$id = isset($input['id']) ? (int)$input['id'] : 0;

if ($id <= 0) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid transaction ID']);
    exit;
}

// Delete transaction
$stmt = $pdo->prepare("DELETE FROM transactions WHERE id = ?");
if ($stmt->execute([$id])) {
    echo json_encode(['status' => 'success', 'message' => 'Transaction deleted successfully']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to delete transaction']);
}
