<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();
require_once __DIR__ . '/../includes/db.php'; // ✅ adjust path if needed

if (!isset($_SESSION['user_id'])) {
    header("Location: /login");
    exit;
}

$stmt = $pdo->prepare("SELECT is_admin FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user || $user['is_admin'] != 1) {
    http_response_code(403);
    echo "<h3 style='color:red;text-align:center;margin-top:50px;'>Access Denied: Admins Only</h3>";
    exit;
}
?>
